/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;

@AdminOnly
public class IconPicker
extends JiraWebActionSupport {
    private String fieldType;
    private String formName;
    private List iconsOfType;
    private Properties iconProperties;
    private Multimap<String, ? extends IssueConstant> issueConstants;
    private String fieldId;
    private static final String ICON_IMAGES_PROPERTIES = "iconimages.properties";
    private final ConstantsManager constantsManager;

    public IconPicker(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getFieldName() {
        return "issue.field." + this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public List getIconUrls(String fieldType) {
        if (this.iconsOfType == null) {
            this.iconsOfType = new ArrayList();
            String fieldTypeLowerCase = fieldType.toLowerCase();
            if (this.getIconProperties() != null) {
                for (Object o : this.getIconProperties().keySet()) {
                    String icon = (String)o;
                    if (!icon.startsWith("icon." + fieldTypeLowerCase)) continue;
                    this.iconsOfType.add(icon);
                }
            } else {
                this.addErrorMessage(this.getText("admin.errors.unable.to.load.properties", "'iconimages.properties'"));
            }
        }
        Collections.sort(this.iconsOfType);
        return this.iconsOfType;
    }

    public String getImage(String key) {
        return this.getIconProperties().getProperty(key);
    }

    private Properties getIconProperties() {
        if (this.iconProperties == null) {
            this.iconProperties = new Properties();
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)ICON_IMAGES_PROPERTIES, ((Object)((Object)this)).getClass());
            try {
                this.iconProperties.load(in);
                in.close();
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to load icon properties from 'iconimages.properties'.");
                return null;
            }
        }
        return this.iconProperties;
    }

    public Collection<? extends IssueConstant> getAssociatedImages(String imageLocation) {
        return this.getIssueConstants().get((Object)imageLocation);
    }

    private Multimap<String, ? extends IssueConstant> getIssueConstants() {
        if (this.issueConstants == null) {
            Collection fields;
            if (this.fieldType.equals("status")) {
                fields = this.constantsManager.getStatuses();
            } else if (this.fieldType.equals("issuetype")) {
                fields = this.constantsManager.getRegularIssueTypeObjects();
            } else if (this.fieldType.equals("priority")) {
                fields = this.constantsManager.getPriorities();
            } else if (this.fieldType.equals("subtasks")) {
                fields = this.constantsManager.getSubTaskIssueTypeObjects();
            } else {
                throw new IllegalArgumentException("Invalid field type selected.");
            }
            this.issueConstants = Multimaps.index((Iterable)fields, (Function)new Function<IssueConstant, String>(){

                public String apply(@Nullable IssueConstant issueConstant) {
                    return issueConstant.getIconUrl();
                }
            });
        }
        return this.issueConstants;
    }
}

