/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class IndexOptimize
extends JiraWebActionSupport {
    private long optimizeTime;
    private final IndexLifecycleManager indexLifecycleManager;

    public IndexOptimize(IndexLifecycleManager indexLifecycleManager) {
        if (indexLifecycleManager == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getName() + " needs a non null instance of: " + IndexLifecycleManager.class.getName());
        }
        this.indexLifecycleManager = indexLifecycleManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (!this.isIndexing()) {
            this.addErrorMessage(this.getText("admin.indexing.optimize.index.disabled"));
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        long optimizeTime = this.indexLifecycleManager.optimize();
        if (optimizeTime < 0L) {
            this.addErrorMessage(this.getText("admin.indexing.optimize.index.nolock"));
            return this.getResult();
        }
        this.setOptimizeTime(optimizeTime);
        return this.getRedirect("IndexOptimize!default.jspa?optimizeTime=" + this.getOptimizeTime());
    }

    public boolean isIndexing() {
        return this.indexLifecycleManager.isIndexAvailable();
    }

    public long getOptimizeTime() {
        return this.optimizeTime;
    }

    public void setOptimizeTime(long optimizeTime) {
        this.optimizeTime = optimizeTime;
    }
}

