/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.GlobalUserPreferencesUtil;
import com.atlassian.jira.web.action.admin.ViewUserDefaultSettings;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class SetGlobalEmailPreference
extends ViewUserDefaultSettings {
    public long effectedUsers;
    private GlobalUserPreferencesUtil userUtil;

    public SetGlobalEmailPreference(GlobalUserPreferencesUtil userUtil) {
        this.userUtil = userUtil;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.effectedUsers = this.userUtil.getTotalUpdateUserCountMailMimeType(this.getApplicationProperties().getDefaultBackedString("user.notifications.mimetype"));
        ComponentAccessor.getUserPreferencesManager().clearCache();
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        String preference = this.getApplicationProperties().getDefaultBackedString("user.notifications.mimetype");
        this.userUtil.updateUserMailMimetypePreference(preference);
        ComponentAccessor.getUserPreferencesManager().clearCache();
        return this.getRedirect("ViewUserDefaultSettings.jspa");
    }

    public long getEffectedUsers() {
        return this.effectedUsers;
    }

    public void setEffectedUsers(long effectedUsers) {
        this.effectedUsers = effectedUsers;
    }

    public String getOtherMimeType() {
        String preference = this.getApplicationProperties().getDefaultBackedString("user.notifications.mimetype");
        if ("text".equalsIgnoreCase(preference)) {
            return "html";
        }
        return "text";
    }
}

