/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.logging.JiraHomeAppender;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.json.JsonUtil;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

@WebSudoRequired
@SystemAdminOnly
public class ViewLogging
extends JiraWebActionSupport {
    protected final LoggingManager loggingManager;
    private List<Logger> loggers;
    private Logger rootLogger;
    private String markMessage;
    private boolean rollOver;
    private static final String AO_LOG = "net.java.ao.DelegateConnectionHandler";
    private static final String AO_LOGGING_CALLSTACK = "net.java.ao.sql.logging.callstack";
    private static final String AO_LOGGING_EXTRA = "net.java.ao.sql.logging.extra";
    private static final Collection<Level> availableLevels = ImmutableList.of((Object)Level.TRACE, (Object)Level.DEBUG, (Object)Level.INFO, (Object)Level.WARN, (Object)Level.ERROR, (Object)Level.FATAL, (Object)Level.OFF);
    private static final String VIEW_LOGGING_JSPA = "ViewLogging.jspa";
    private static final String HASH_HTTP = "#http";
    private static final String HASH_SQL = "#sql";
    private static final String HASH_PROFILING = "#profiling";
    private static final String HASH_MAIL = "#mail";
    private static final String HTTP_ACCESS_LOG = "com.atlassian.jira.web.filters.accesslog.AccessLogFilter";
    private static final String HTTP_DUMP_LOG = "com.atlassian.jira.web.filters.accesslog.AccessLogFilterDump";
    private static final String HTTP_ACCESS_LOG_INCLUDE_IMAGES = "com.atlassian.jira.web.filters.accesslog.AccessLogFilterIncludeImages";
    private static final String SQL_LOG = "com.atlassian.jira.ofbiz.LoggingSQLInterceptor";
    private static final Set<String> LOGGER_NAME_EXEMPTION_SET;
    private final MailServerManager mailServerManager;
    private final MailLoggingManager mailLoggingManager;

    public ViewLogging(MailServerManager mailServerManager, MailLoggingManager mailLoggingManager, LoggingManager loggingManager) {
        this.mailServerManager = mailServerManager;
        this.mailLoggingManager = mailLoggingManager;
        this.loggingManager = loggingManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public Collection<Logger> getLoggers() {
        if (this.loggers == null) {
            this.loggers = new ArrayList<Logger>();
            LoggerContext context = (LoggerContext)LogManager.getContext((ClassLoader)LogManager.class.getClassLoader(), (boolean)false);
            Map currentLoggers = context.getConfiguration().getLoggers();
            for (LoggerConfig logger : currentLoggers.values()) {
                if (logger.getLevel() == null || LOGGER_NAME_EXEMPTION_SET.contains(logger.getName()) || this.mailLoggingManager.isMailRelatedLogger(org.apache.log4j.Logger.getLogger((String)logger.getName()))) continue;
                this.loggers.add(LogManager.getLogger((String)logger.getName()));
            }
            this.loggers.sort(new LoggerComparator());
        }
        return this.loggers;
    }

    public Logger getRootLogger() {
        if (this.rootLogger == null) {
            this.rootLogger = LogManager.getRootLogger();
        }
        return this.rootLogger;
    }

    public Collection<Level> getAvailableLevels() {
        return availableLevels;
    }

    public String getAvailableLevelsAsJson() {
        return JsonUtil.toJsonString(ImmutableList.copyOf((Collection)this.getAvailableLevels().stream().map(Level::toString).collect(Collectors.toList())));
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doMarkLogs() throws Exception {
        String msg = this.getMarkMessage();
        this.loggingManager.markLogs(msg, this.rollOver);
        return this.getRedirect(VIEW_LOGGING_JSPA);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableProfiling() throws Exception {
        this.loggingManager.enableProfiling();
        return this.getRedirect("ViewLogging.jspa#profiling");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableProfiling() throws Exception {
        this.loggingManager.disableProfiling();
        return this.getRedirect("ViewLogging.jspa#profiling");
    }

    public boolean isProfilingEnabled() {
        return Timers.getConfiguration().isEnabled();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableHttpAccessLog() {
        this.loggingManager.setLogLevel(this.getHttpAccessLogger(), Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableHttpAccessLog() {
        this.loggingManager.setLogLevel(this.getHttpAccessLogger(), Level.OFF);
        this.loggingManager.setLogLevel(this.getHttpAccessIncludeImagesLogger(), Level.OFF);
        this.loggingManager.setLogLevel(this.getHttpDumpLogger(), Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpAccessLogger() {
        return LogManager.getLogger((String)HTTP_ACCESS_LOG);
    }

    public boolean isHttpAccessLogEnabled() {
        return this.getHttpAccessLogger().getLevel() != Level.OFF;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableHttpDumpLog() {
        this.loggingManager.setLogLevel(this.getHttpDumpLogger(), Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableHttpDumpLog() {
        this.loggingManager.setLogLevel(this.getHttpDumpLogger(), Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpDumpLogger() {
        return LogManager.getLogger((String)HTTP_DUMP_LOG);
    }

    public boolean isHttpDumpLogEnabled() {
        return this.getHttpDumpLogger().getLevel() != Level.OFF;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableHttpAccessLogIncludeImages() {
        this.loggingManager.setLogLevel(this.getHttpAccessIncludeImagesLogger(), Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableHttpAccessLogIncludeImages() {
        this.loggingManager.setLogLevel(this.getHttpAccessIncludeImagesLogger(), Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpAccessIncludeImagesLogger() {
        return LogManager.getLogger((String)HTTP_ACCESS_LOG_INCLUDE_IMAGES);
    }

    public boolean isHttpAccessLogIncludeImagesEnabled() {
        return this.getHttpAccessIncludeImagesLogger().getLevel() != Level.OFF;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableSqlLog() {
        this.loggingManager.setLogLevel(this.getSqlLogger(), Level.INFO);
        this.loggingManager.setLogLevel(this.getActiveObjectsLogger(), Level.DEBUG);
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_EXTRA, (Object)Boolean.TRUE.toString());
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_CALLSTACK, (Object)Boolean.FALSE.toString());
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableSqlLog() {
        this.loggingManager.setLogLevel(this.getSqlLogger(), Level.OFF);
        this.loggingManager.setLogLevel(this.getActiveObjectsLogger(), Level.OFF);
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_EXTRA, (Object)Boolean.FALSE.toString());
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_CALLSTACK, (Object)Boolean.FALSE.toString());
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableSqlDumpLog() {
        this.loggingManager.setLogLevel(this.getSqlLogger(), Level.DEBUG);
        this.loggingManager.setLogLevel(this.getActiveObjectsLogger(), Level.DEBUG);
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_EXTRA, (Object)Boolean.TRUE.toString());
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_CALLSTACK, (Object)Boolean.TRUE.toString());
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableSqlDumpLog() {
        this.loggingManager.setLogLevel(this.getSqlLogger(), Level.INFO);
        this.loggingManager.setLogLevel(this.getActiveObjectsLogger(), Level.DEBUG);
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_EXTRA, (Object)Boolean.TRUE.toString());
        JiraSystemProperties.getInstance().setProperty(AO_LOGGING_CALLSTACK, (Object)Boolean.FALSE.toString());
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    private Logger getSqlLogger() {
        return LogManager.getLogger((String)SQL_LOG);
    }

    private Logger getActiveObjectsLogger() {
        return LogManager.getLogger((String)AO_LOG);
    }

    public boolean isSqlLogEnabled() {
        return this.getSqlLogger().getLevel() != Level.OFF;
    }

    public boolean isSqlDumpLogEnabled() {
        return this.getSqlLogger().getLevel() == Level.DEBUG;
    }

    public boolean isAtLevel(Logger logger, String targetLevel) {
        String loggerLevelName = logger.getLevel().toString();
        return targetLevel.equals(loggerLevelName);
    }

    public Logger getOutgoingMailLogger() {
        return LogManager.getLogger((String)"com.atlassian.mail");
    }

    public boolean isOutgoingMailLoggingEnabled() {
        return this.mailLoggingManager.getOutgoingMailLoggingLevel() != org.apache.log4j.Level.OFF;
    }

    public boolean isOutgoingMailDebugEnabled() {
        return this.mailLoggingManager.getOutgoingMailLoggingLevel() == org.apache.log4j.Level.DEBUG;
    }

    public boolean isIncomingMailLoggingEnabled() {
        return this.mailLoggingManager.getIncomingMailLoggingLevel() != org.apache.log4j.Level.OFF;
    }

    public boolean isIncomingMailDebugEnabled() {
        return this.mailLoggingManager.getIncomingMailLoggingLevel() == org.apache.log4j.Level.DEBUG;
    }

    public boolean isOutgoingMailServerDefined() {
        return this.mailServerManager.getDefaultSMTPMailServer() != null;
    }

    public boolean isIncomingMailServerDefined() {
        return !this.mailServerManager.getIncomingMailServers().isEmpty();
    }

    @Nullable
    public String getOutgoingMailFirstLogFileName() {
        return StringUtils.defaultString((String)this.getFirstFileAppenderFileName(LogManager.getLogger((String)this.mailLoggingManager.getOutgoingMailLogger().getName())), (String)"atlassian-jira-outgoing-mail.log");
    }

    @Nullable
    public String getIncomingMailFirstLogFileName() {
        return StringUtils.defaultString((String)this.getFirstFileAppenderFileName(LogManager.getLogger((String)this.mailLoggingManager.getIncomingMailLogger().getName())), (String)"atlassian-jira-incoming-mail.log");
    }

    @Nullable
    public String getFirstFileAppenderFileName(Logger logger) {
        Map appenders = ((org.apache.logging.log4j.core.Logger)logger).getAppenders();
        Appender fileAppender = appenders.values().stream().filter(input -> {
            if (input instanceof JiraHomeAppender) {
                return ((JiraHomeAppender)input).getFile() != null;
            }
            return Log4jKit.getLogFileName(input.getName()) != null;
        }).findFirst().orElse(null);
        if (fileAppender == null) {
            return null;
        }
        if (fileAppender instanceof JiraHomeAppender) {
            return FilenameUtils.getName((String)((JiraHomeAppender)fileAppender).getFile());
        }
        File file = Log4jKit.getLogFileName(fileAppender.getName());
        return file != null ? file.getName() : null;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableOutgoingMailLogging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableOutgoingMailLogging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.OFF);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableOutgoingMailDebugging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableOutgoingMailDebugging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.DEBUG);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableIncomingMailLogging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableIncomingMailLogging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.OFF);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDisableIncomingMailDebugging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doEnableIncomingMailDebugging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.DEBUG);
    }

    private String setOutgoingMailLoggingLevelAndRedirectBack(Level loggingLevel) {
        this.mailLoggingManager.setOutgoingMailLoggingLevel(org.apache.log4j.Level.toLevel((String)loggingLevel.name()));
        return this.getRedirect("ViewLogging.jspa#mail");
    }

    private String setIncomingMailLoggingLevelAndRedirectBack(Level loggingLevel) {
        this.mailLoggingManager.setIncomingMailLoggingLevel(org.apache.log4j.Level.toLevel((String)loggingLevel.name()));
        return this.getRedirect("ViewLogging.jspa#mail");
    }

    public String getMarkMessage() {
        return this.markMessage;
    }

    public void setMarkMessage(String markMessage) {
        this.markMessage = markMessage;
    }

    public boolean isRollOver() {
        return this.rollOver;
    }

    public void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(SQL_LOG);
        set.add(HTTP_ACCESS_LOG);
        set.add(HTTP_DUMP_LOG);
        set.add(HTTP_ACCESS_LOG_INCLUDE_IMAGES);
        set.add(AO_LOG);
        set.add("");
        LOGGER_NAME_EXEMPTION_SET = Collections.unmodifiableSet(set);
    }

    private static class LoggerComparator
    implements Comparator<Logger> {
        private LoggerComparator() {
        }

        @Override
        public int compare(Logger o1, Logger o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1 == null || name2 == null) {
                return 0;
            }
            return name1.compareTo(name2);
        }
    }
}

