/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.avatars;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class EditAvatarSettings
extends JiraWebActionSupport {
    private final transient GravatarSettings gravatarSettings;
    private boolean useGravatar;
    private String gravatarApiAddress;

    public EditAvatarSettings(GravatarSettings gravatarSettings) {
        this.gravatarSettings = Objects.requireNonNull(gravatarSettings);
    }

    @ActionViewData
    public boolean isUseGravatar() {
        return this.useGravatar;
    }

    @ActionViewData
    public void setUseGravatar(boolean useGravatar) {
        this.useGravatar = useGravatar;
    }

    @ActionViewData
    public String getGravatarApiAddress() {
        return this.gravatarApiAddress;
    }

    @ActionViewData
    public void setGravatarApiAddress(String gravatarApiAddress) {
        this.gravatarApiAddress = gravatarApiAddress;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        this.gravatarApiAddress = this.gravatarSettings.getCustomApiAddress();
        this.useGravatar = this.gravatarSettings.isAllowGravatars();
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        this.gravatarSettings.setAllowGravatars(this.useGravatar);
        this.gravatarSettings.setCustomApiAddress(StringUtils.trimToNull((String)this.gravatarApiAddress));
        return this.returnComplete("ViewAvatarSettings.jspa");
    }
}

