/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.cluster;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.cluster.ReplicationSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

@AdminOnly
public class EditReplicationSettings
extends ReplicationSettings {
    @VisibleForTesting
    static final String FILE_TYPE_CHECKBOX_NAME = "enabledFileType";
    private static final String REPLICATION_SETTINGS_PAGE = "ReplicationSettings.jspa";

    public EditReplicationSettings(SecondaryJiraHome secondaryJiraHome, ClusterManager clusterManager, JiraHomeReplicatorService jiraHomeReplicatorService) {
        super(secondaryJiraHome, clusterManager, jiraHomeReplicatorService);
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        Collection<String> updatedFileTypes = this.getUpdatedFileTypes();
        this.secondaryJiraHome.applySettings(updatedFileTypes.contains(JiraHomeChangeEvent.FileType.ATTACHMENT.getKey()), updatedFileTypes.contains(JiraHomeChangeEvent.FileType.PLUGIN.getKey()), updatedFileTypes.contains(JiraHomeChangeEvent.FileType.INDEX_SNAPSHOT.getKey()), updatedFileTypes.contains(JiraHomeChangeEvent.FileType.AVATAR.getKey()));
        return this.returnComplete(REPLICATION_SETTINGS_PAGE);
    }

    @ActionViewData
    public String getFileTypeCheckboxName() {
        return FILE_TYPE_CHECKBOX_NAME;
    }

    private Collection<String> getUpdatedFileTypes() {
        return Optional.ofNullable(this.getHttpRequest().getParameterValues(this.getFileTypeCheckboxName())).map(fileTypes -> new HashSet<String>(Arrays.asList(fileTypes))).orElse(new HashSet());
    }
}

