/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.cluster;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@WebSudoRequired
@AdminOnly
public class ReplicationSettings
extends JiraWebActionSupport {
    private static final ImmutableMap<JiraHomeChangeEvent.FileType, String> i18nKey = new ImmutableMap.Builder().put((Object)JiraHomeChangeEvent.FileType.AVATAR, (Object)"'admin.replicationsettings.avatars.enabled'").put((Object)JiraHomeChangeEvent.FileType.ATTACHMENT, (Object)"'admin.systeminfo.attachments'").put((Object)JiraHomeChangeEvent.FileType.INDEX_SNAPSHOT, (Object)"'admin.replicationsettings.index.snapshots.enabled'").put((Object)JiraHomeChangeEvent.FileType.PLUGIN, (Object)"'admin.plugins.installed.plugins'").build();
    private static final Map<JiraHomeChangeEvent.FileType, String> FILE_TYPE_CONFIG_URIS = new EnumMap<JiraHomeChangeEvent.FileType, String>(JiraHomeChangeEvent.FileType.class);
    protected final transient SecondaryJiraHome secondaryJiraHome;
    private final transient ClusterManager clusterManager;
    private final transient JiraHomeReplicatorService jiraHomeReplicatorService;
    private Boolean replicating;

    public ReplicationSettings(SecondaryJiraHome secondaryJiraHome, ClusterManager clusterManager, JiraHomeReplicatorService jiraHomeReplicatorService) {
        this.secondaryJiraHome = Objects.requireNonNull(secondaryJiraHome);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.jiraHomeReplicatorService = Objects.requireNonNull(jiraHomeReplicatorService);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.isReplicateRequested()) {
            this.jiraHomeReplicatorService.replicateJiraHome();
        }
        return this.getRedirect("ReplicationSettings!default.jspa");
    }

    @ActionViewData
    public boolean isReplicationEnabled() {
        return this.secondaryJiraHome.isEnabled();
    }

    @ActionViewData
    public String getReplicationPath() {
        if (!this.isReplicationEnabled()) {
            return "";
        }
        return this.secondaryJiraHome.getHomePath();
    }

    @ActionViewData
    public boolean isClusterLicensed() {
        return this.clusterManager.isClusterLicensed();
    }

    @ActionViewData
    public boolean isReplicating() {
        if (this.replicating == null) {
            this.replicating = this.isReplicateRequested() || this.jiraHomeReplicatorService.isReplicating();
        }
        return this.replicating;
    }

    private boolean isReplicateRequested() {
        return this.getHttpRequest().getParameter("ReplicateRequested") != null;
    }

    @ActionViewData
    public Map<JiraHomeChangeEvent.FileType, String> getNonReplicableFileTypes() {
        EnumSet<JiraHomeChangeEvent.FileType> replicableFileTypes = EnumSet.copyOf(this.getReplicableFileTypes());
        LinkedHashMap<JiraHomeChangeEvent.FileType, String> map = new LinkedHashMap<JiraHomeChangeEvent.FileType, String>(FILE_TYPE_CONFIG_URIS);
        replicableFileTypes.forEach(map::remove);
        return map;
    }

    @ActionViewData
    public Collection<JiraHomeChangeEvent.FileType> getReplicableFileTypes() {
        return this.jiraHomeReplicatorService.getReplicableFileTypes();
    }

    @ActionViewData
    public String getI18nKey(JiraHomeChangeEvent.FileType fileType) {
        return (String)i18nKey.get((Object)fileType);
    }

    @ActionViewData
    public Boolean getFileTypeEnabled(JiraHomeChangeEvent.FileType fileType) {
        return this.getApplicationProperties().getOption(fileType.getKey());
    }

    static {
        FILE_TYPE_CONFIG_URIS.put(JiraHomeChangeEvent.FileType.ATTACHMENT, "/secure/admin/ViewAttachmentSettings.jspa");
        FILE_TYPE_CONFIG_URIS.put(JiraHomeChangeEvent.FileType.AVATAR, "/secure/admin/ViewAvatarSettings.jspa");
    }
}

