/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class DeleteCustomField
extends JiraWebActionSupport {
    private CustomField customField;
    private Long id;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldService customFieldService;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public DeleteCustomField(CustomFieldService customFieldService, CustomFieldManager customFieldManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.validateFieldLocked()) {
            return "error";
        }
        return super.doDefault();
    }

    public void doValidation() {
        if (!this.validateFieldLocked()) {
            return;
        }
        this.customFieldService.validateDelete(this.getJiraServiceContext(), this.getId());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.customFieldManager.removeCustomField(this.getCustomField());
        return this.getRedirect("ViewCustomFields.jspa");
    }

    public boolean isFieldManaged() {
        return this.getManagedConfigurationEntity().isManaged();
    }

    public boolean isFieldLocked() {
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationEntity());
    }

    public String getManagedFieldDescriptionKey() {
        return this.getManagedConfigurationEntity().getDescriptionI18nKey();
    }

    private boolean validateFieldLocked() {
        if (this.isFieldLocked()) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.delete.locked", this.getCustomField().getName()));
            return false;
        }
        return true;
    }

    private ManagedConfigurationItem getManagedConfigurationEntity() {
        return this.managedConfigurationItemService.getManagedCustomField(this.getCustomField());
    }

    public CustomField getCustomField() {
        if (this.customField == null) {
            this.customField = this.customFieldManager.getCustomFieldObject(this.getId());
        }
        return this.customField;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

