/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.user.UserFilterUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.WebResourceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

@WebSudoRequired
@AdminOnly
public class EditCustomFieldUserPickerFilter
extends AbstractEditConfigurationItemAction {
    static final String REDIRECT_URL_PREFIX = "ConfigureCustomField!default.jspa?customFieldId=";
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserFilterManager userFilterManager;
    private final WebResourceManager webResourceManager;
    private String filterJson = null;

    public EditCustomFieldUserPickerFilter(GroupManager groupManager, ManagedConfigurationItemService managedConfigurationItemService, ProjectRoleManager projectRoleManager, UserFilterManager userFilterManager, WebResourceManager webResourceManager) {
        super(managedConfigurationItemService);
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.userFilterManager = userFilterManager;
        this.webResourceManager = webResourceManager;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doSave() throws JSONException {
        try {
            UserFilter filter = UserFilterUtils.fromJsonString((String)this.filterJson);
            this.userFilterManager.updateFilter(this.getFieldConfig(), filter);
        }
        catch (JSONException e) {
            this.log.error((Object)"Unable to parse the returned user filter", (Throwable)e);
        }
        return this.redirectToView();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.webResourceManager.requireResource("jira.webresources:user-picker-filter-configuration-resources");
        return "input";
    }

    public void setUserFilterJson(String userFilterJson) {
        this.filterJson = userFilterJson;
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        Collection<ProjectRole> allProjectRoles = this.getAllProjectRoles();
        Collection<Group> allGroups = this.getAllGroups();
        FieldConfig fieldConfig = this.getFieldConfig();
        UserFilter filter = this.getFilter(fieldConfig, allGroups);
        HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("configcustomfield");
        return ImmutableMap.builder().put((Object)"atl_token", (Object)this.getXsrfToken()).put((Object)"customField", (Object)this.getCustomField()).put((Object)"fieldConfig", (Object)fieldConfig).put((Object)"groupsJson", (Object)this.getGroupsAsJsonString(allGroups)).put((Object)"helpPath", (Object)helpPath).put((Object)"projectRolesJson", (Object)this.getProjectRolesAsJsonString(allProjectRoles)).put((Object)"userFilter", (Object)filter).put((Object)"userFilterJson", (Object)this.getFilterAsJsonString(filter, allProjectRoles)).build();
    }

    @VisibleForTesting
    UserFilter getFilter(FieldConfig fieldConfig, Collection<Group> allGroups) {
        return UserFilterUtils.getFilterWithoutRemovedGroupsAndRoles((UserFilter)this.userFilterManager.getFilter(fieldConfig), allGroups, (ProjectRoleManager)this.projectRoleManager);
    }

    private Collection<Group> getAllGroups() {
        return this.groupManager.getAllGroups();
    }

    private String redirectToView() {
        return this.getRedirect(REDIRECT_URL_PREFIX + this.getCustomField().getIdAsLong());
    }

    private Collection<ProjectRole> getAllProjectRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    private String getFilterAsJsonString(UserFilter filter, Collection<ProjectRole> allProjectRoles) {
        try {
            return UserFilterUtils.toJson((UserFilter)filter, (ProjectRoleManager)this.projectRoleManager).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of user filter: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private String getGroupsAsJsonString(Collection<Group> groups) {
        JSONArray root = new JSONArray();
        for (Group group : groups) {
            JSONObject groupJson = new JSONObject();
            try {
                groupJson.put("name", (Object)group.getName());
            }
            catch (JSONException e) {
                this.log.warn((Object)("skipping project role object that could not converted to json: " + group.getName() + " - " + e.getMessage()));
            }
            root.put((Object)groupJson);
        }
        return root.toString();
    }

    private String getProjectRolesAsJsonString(Collection<ProjectRole> projectRoles) {
        JSONArray root = new JSONArray();
        for (ProjectRole projectRole : projectRoles) {
            JSONObject role = new JSONObject();
            try {
                role.put("id", (Object)projectRole.getId());
                role.put("name", (Object)projectRole.getName());
                role.put("description", (Object)projectRole.getDescription());
            }
            catch (JSONException e) {
                this.log.warn((Object)("skipping project role object that could not converted to json: " + projectRole + " - " + e.getMessage()));
            }
            root.put((Object)role);
        }
        return root.toString();
    }
}

