/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;

@WebSudoRequired
@AdminOnly
public class EditVersionPickerCustomFieldOptionsOrder
extends AbstractEditConfigurationItemAction {
    private final I18nHelper i18nHelper;
    private final GenericConfigManager genericConfigManager;

    public EditVersionPickerCustomFieldOptionsOrder(ManagedConfigurationItemService managedConfigurationItemService, I18nHelper i18nHelper, GenericConfigManager genericConfigManager) {
        super(managedConfigurationItemService);
        this.i18nHelper = i18nHelper;
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setReturnUrl(null);
        if (!(this.getCustomField().getCustomFieldType() instanceof VersionCFType)) {
            this.addErrorMessage(this.getText("admin.errors.customfields.cannot.set.options", "'" + this.getCustomField().getCustomFieldType().getName() + "'"));
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        CustomField customField = this.getCustomField();
        HashMap map = new HashMap();
        ActionContext.getContext();
        Map actionParams = ActionContext.getParameters();
        customField.populateFromParams(map, actionParams);
        int versionOrder = this.retrieveVersionOrderParam(actionParams);
        this.setVersionOrder(this.getFieldConfig(), versionOrder);
        return this.getRedirect("ConfigureCustomField!default.jspa?customFieldId=" + customField.getIdAsLong());
    }

    protected void doValidation() {
        if (this.getCustomField() == null) {
            this.addErrorMessage(this.getText("admin.errors.customfields.no.field.selected.for.edit"));
        }
        if (this.validateFieldLocked()) {
            return;
        }
    }

    private void setVersionOrder(FieldConfig fieldConfig, int versionOrder) {
        this.genericConfigManager.update(VersionCFType.VersionOrder.getDatabaseType(), fieldConfig.getId().toString(), (Object)versionOrder);
    }

    private int retrieveVersionOrderParam(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            String key = parameter.getKey();
            String customFieldKey = CustomFieldUtils.getCustomFieldKey((String)key);
            if (key == null || !this.getCustomField().getId().equals(customFieldKey)) continue;
            return Integer.parseInt(parameter.getValue()[0]);
        }
        return -1;
    }

    public Map<Integer, String> getVersionOrderSelectList() throws Exception {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (VersionCFType.VersionOrder versionOrder : VersionCFType.VersionOrder.values()) {
            map.put(versionOrder.getId(), versionOrder.getTranslation(this.i18nHelper));
        }
        return map;
    }

    public String getVersionOrder() throws Exception {
        Object versionOrder = this.genericConfigManager.retrieve(VersionCFType.VersionOrder.getDatabaseType(), this.getFieldConfig().getId().toString());
        if (versionOrder != null) {
            return versionOrder.toString();
        }
        return null;
    }
}

