/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.user.ConfigurePortalPages;
import com.atlassian.jira.web.action.util.PortalPageDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.atlassian.jira.web.ui.model.DropDownModel;
import com.atlassian.jira.web.ui.model.DropDownModelBuilder;
import com.atlassian.jira.web.ui.model.DropDownModelProvider;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.WebResourceManager;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

@WebSudoRequired
@AdminOnly
public class ViewSharedDashboards
extends ConfigurePortalPages
implements SharedEntitySearchAction,
DropDownModelProvider<PortalPageDisplayBean> {
    private static final String CONTENTONLY = "contentonly";
    private final ConfigurePortalPages.PortalPageViewHelper dashboardViewHelper;
    private final FeatureManager featureManager;

    public ViewSharedDashboards(PortalPageService portalPageService, JiraAuthenticationContext authCtx, FavouritesService favouritesService, GlobalPermissionManager permissionManager, ShareTypeFactory shareTypeFactory, UserFormats userFormats, WebResourceManager webResourceManager, UserHistoryManager userHistoryManager, ShareManager shareManager, FeatureManager featureManager, UserManager userManager) {
        super(portalPageService, authCtx, favouritesService, permissionManager, shareTypeFactory, userFormats, webResourceManager, userHistoryManager, shareManager, featureManager, userManager);
        this.dashboardViewHelper = new PortalViewHelper(shareTypeFactory, authCtx, ActionContext.getRequest().getContextPath(), "ViewSharedDashboards.jspa", portalPageService, featureManager, userManager, permissionManager);
        this.featureManager = featureManager;
    }

    @Override
    public DropDownModel getDropDownModel(PortalPageDisplayBean displayBean, int listIndex) {
        DropDownModelBuilder builder = DropDownModelBuilder.builder();
        builder.setTopText(this.getText("common.words.operations"));
        builder.startSection().addItem(builder.item().setText(this.getText("shareddashboards.admin.cog.changeowner")).setAttr("id", "change_owner_" + displayBean.getId()).setAttr("class", "change-owner").setAttr("href", this.toUrl(displayBean, "ChangeSharedDashboardOwner!default.jspa", "dashboardId", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get()))).addItem(builder.item().setText(this.getText("shareddashboards.delete")).setAttr("id", "delete_" + displayBean.getId()).setAttr("class", "delete-dashboard").setAttr("href", this.toUrl(displayBean, "DeleteSharedDashboard!default.jspa", "dashboardId", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get())));
        builder.endSection();
        return builder.build();
    }

    private String buildQueryStringForModel(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder("");
        if (request.getMethod().equalsIgnoreCase("POST")) {
            builder.append("&");
            builder.append("searchOwnerUserName=");
            builder.append(JiraUrlCodec.encode((String)this.getSearchOwnerUserName()));
            builder.append("&searchName=");
            builder.append(JiraUrlCodec.encode((String)this.getSearchName()));
        } else if (this.getQueryString() != null) {
            builder.append("&");
            builder.append(this.getQueryString());
        }
        builder.append("&totalResultCount=").append(JiraUrlCodec.encode((String)("" + this.getTotalResultCount())));
        return builder.toString();
    }

    @Override
    public String doDefault() {
        return this.executeSearchView();
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() {
        this.setReturnUrl("ViewSharedDashboards.jspa");
        return this.executeSearchView();
    }

    private String executeSearchView() {
        JiraServiceContext ctx = this.getJiraServiceContext();
        SharedEntitySearchViewHelper.SearchResult<PortalPage> searchResults = this.getPortalPageViewHelper().search(ctx);
        this.setSearchResults(searchResults);
        if (!ctx.getErrorCollection().hasAnyErrors()) {
            this.setPages(this.transformToDisplayBeans(searchResults.getResults()));
        }
        return this.isContentOnly() ? CONTENTONLY : "success";
    }

    @Override
    public ConfigurePortalPages.PortalPageViewHelper getPortalPageViewHelper() {
        return this.dashboardViewHelper;
    }

    private String getQueryString() {
        return ExecutingHttpRequest.get().getQueryString();
    }

    public boolean isManageAllDashboards() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }

    private static class PortalViewHelper
    extends ConfigurePortalPages.PortalPageViewHelper {
        public PortalViewHelper(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, String applicationContext, String actionUrlPrefix, PortalPageService portalPageService, FeatureManager featureManager, UserManager userManager, GlobalPermissionManager permissionManager) {
            super(shareTypeFactory, authCtx, applicationContext, actionUrlPrefix, portalPageService, featureManager, userManager, permissionManager);
        }

        @Override
        public SharedEntitySearchContext getEntitySearchContext() {
            return SharedEntitySearchContext.ADMINISTER;
        }
    }
}

