/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.filters.AbstractAdministerFilter;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
public class ChangeSharedFilterOwner
extends AbstractAdministerFilter {
    private ApplicationUser ownerUserObj;
    private String owner;
    private String ownerError;
    private static final String FILTERNAME = "filterName";
    private final UserSearchService userSearchService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionManager;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;

    public ChangeSharedFilterOwner(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, PermissionManager permissionManager, SearchRequestManager searchRequestManager, UserSearchService userSearchService, AvatarService avatarService, UserManager userManager, ShareTypeValidatorUtils shareTypeValidatorUtils) {
        super(issueSearcherManager, searchRequestService, searchService, permissionManager, searchRequestManager);
        this.permissionManager = permissionManager;
        this.searchRequestService = searchRequestService;
        this.userSearchService = userSearchService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.shareTypeValidatorUtils = shareTypeValidatorUtils;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        JiraServiceContext contextWithOwner = this.getJiraServiceContext(this.owner);
        this.searchRequestService.validateFilterForChangeOwner(contextWithOwner, this.getFilter());
        this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(contextWithOwner.getErrorCollection()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        JiraServiceContextImpl contextWithCurrentUser = new JiraServiceContextImpl(this.getJiraServiceContext().getLoggedInApplicationUser());
        this.searchRequestService.updateFilterOwner((JiraServiceContext)contextWithCurrentUser, this.getFilter().getId(), this.getFilter().getOwner());
        this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(contextWithCurrentUser.getErrorCollection()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private ErrorCollection convertDelegatedUserAndFilterNameErrorsToMessages(ErrorCollection errorCollection) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessages(errorCollection.getErrorMessages());
        String delegatedUserError = (String)errorCollection.getErrors().get("shares_delegated");
        String filterNameError = (String)errorCollection.getErrors().get(FILTERNAME);
        if (StringUtils.isNotBlank((CharSequence)delegatedUserError)) {
            errors.addErrorMessage(delegatedUserError);
        }
        if (StringUtils.isNotBlank((CharSequence)filterNameError)) {
            errors.addErrorMessage(filterNameError);
        }
        return errors;
    }

    protected void doValidation() {
        if (StringUtils.isBlank((CharSequence)this.ownerError)) {
            this.setOwnerError(null);
        }
        if (StringUtils.isBlank((CharSequence)this.owner)) {
            this.setOwnerError("");
            this.addError("owner", this.getText("sharedfilters.admin.filter.owner.empty"));
        } else {
            this.validateUserExists(this.owner);
        }
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceCtx = this.getJiraServiceContext(this.owner);
            this.getFilter().setOwner(this.userManager.getUserByName(this.owner));
            this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, (SharedEntity)this.getFilter());
            this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(serviceCtx.getErrorCollection()));
        }
    }

    public boolean canChangeOwner() {
        return !this.hasAnyErrors();
    }

    public boolean userPickerDisabled() {
        return !this.userSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public ApplicationUser getOwnerUserObj() throws Exception {
        if (this.getOwner() != null && this.ownerUserObj == null) {
            this.ownerUserObj = this.userManager.getUserByName(this.owner);
        }
        return this.ownerUserObj;
    }

    public String getOwner() {
        SearchRequest filter = this.getFilter();
        return filter.getOwner() == null ? null : filter.getOwner().getUsername();
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    private void validateUserExists(String ownerUsername) {
        if (this.userManager.getUserByName(ownerUsername) == null) {
            this.addError("owner", this.getText("sharedfilters.admin.filter.owner.does.not.exist", ownerUsername));
            this.setOwnerError(ownerUsername);
        }
    }

    public URI getOwnerUserAvatarUrl() {
        return this.avatarService.getAvatarUrlNoPermCheck(this.getOwner(), Avatar.Size.SMALL);
    }

    public String getOwnerError() {
        return this.ownerError;
    }

    public void setOwnerError(String ownerError) {
        this.ownerError = ownerError;
    }

    private JiraServiceContext getJiraServiceContext(String owner) {
        Object ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(UserUtils.getUser((String)owner)) : this.getJiraServiceContext();
        return ctx;
    }
}

