/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterDeletionWarningViewProvider;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.filter.FilterDeletionVerifierManager;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.filters.AbstractAdministerFilter;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
public class DeleteSharedFilter
extends AbstractAdministerFilter {
    private static final int FILTERS_PER_PAGE = 20;
    private final SearchRequestService searchRequestService;
    private final FilterDeletionWarningViewProvider filterDeletionWarningViewProvider;
    private final FilterDeletionVerifierManager filterDeletionVerifierManager;

    public DeleteSharedFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, PermissionManager permissionManager, SearchRequestManager searchRequestManager, FilterDeletionWarningViewProvider filterDeletionWarningViewProvider, FilterDeletionVerifierManager filterDeletionVerifierManager) {
        super(issueSearcherManager, searchRequestService, searchService, permissionManager, searchRequestManager);
        this.searchRequestService = searchRequestService;
        this.filterDeletionWarningViewProvider = filterDeletionWarningViewProvider;
        this.filterDeletionVerifierManager = filterDeletionVerifierManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(this.getJiraServiceContext(this.getFilterId()), this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        this.repaginateIfNeeded();
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private void repaginateIfNeeded() {
        int newResultCount;
        int pagingOffset = StringUtils.isNotBlank((CharSequence)this.getPagingOffset()) ? Integer.parseInt(this.getPagingOffset()) - 1 : -1;
        int n = newResultCount = StringUtils.isNotBlank((CharSequence)this.getTotalResultCount()) ? Integer.parseInt(this.getTotalResultCount()) - 1 : -1;
        if (pagingOffset >= 0) {
            this.setTotalResultCount("" + newResultCount);
            if (newResultCount % 20 == 0) {
                this.setPagingOffset("" + pagingOffset);
            }
        }
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    public String getWarningHtml() {
        return this.filterDeletionWarningViewProvider.getWarningHtml(this.getFilter());
    }

    public boolean shouldShowDeleteButton() {
        return this.filterDeletionVerifierManager.canDeleteFilter(this.getFilterId());
    }
}

