/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.importer.project.AbstractProjectImportProgress;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportProgressTrackerUtil;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@WebSudoRequired
@SystemAdminOnly
public class ProjectImportProgress
extends AbstractProjectImportProgress<ProjectImportResults> {
    private final TaskManager taskManager;

    public ProjectImportProgress(TaskManager taskManager, TaskDescriptorBean.Factory factory, JiraPageBuilderService jiraPageBuilderService, ProjectImportProgressTrackerUtil projectImportProgressTrackerUtil) {
        super(taskManager, factory, jiraPageBuilderService, projectImportProgressTrackerUtil);
        this.taskManager = taskManager;
    }

    @Override
    protected boolean taskIsComplete() {
        return ProjectImportBean.getProjectImportBeanFromSession().getProjectImportResults() != null;
    }

    @Override
    protected String handleFinishedTask(TaskDescriptorBean<ProjectImportResults> ourTask) throws ExecutionException, InterruptedException {
        ProjectImportResults projectImportResults = ourTask.getResult();
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        if (projectImportResults == null) {
            if (projectImportBean.getProjectImportData() == null) {
                return this.getRedirect("ProjectImportSelectProject!errorFromProgress.jspa");
            }
            return this.getRedirect("ProjectImportSummary!default.jspa");
        }
        this.taskManager.removeTask(projectImportBean.getTaskProgressInformation().getTaskId());
        projectImportBean.getTaskProgressInformation().setTaskId(null);
        projectImportBean.setProjectImportResults(projectImportResults);
        return this.getRedirect(this.getRedirectOnComplete());
    }

    @Override
    @ActionViewData
    public List<Map<String, Object>> getProgressTrackerSteps() {
        return this.getProgressTrackerSteps(ProjectImportProgressTrackerUtil.Page.IMPORT_PROJECT);
    }

    @Override
    protected String getSubmitUrl() {
        return "ProjectImportProgress.jspa";
    }
}

