/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

@Internal
@VisibleForTesting
public class IndexRecoveryCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private static final String REINDEX_PERCENT = "admin.indexing.percent.complete";
    private static final String REINDEX_CURRENT = "admin.indexing.current.index";
    private static final String RECOVERY_MESSAGE = "admin.index.recovery.message";
    private final ApplicationUser user;
    private final IndexRecoveryService indexRecoveryService;
    private final JohnsonProvider johnsonProvider;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;
    private String recoveryFilename;

    public IndexRecoveryCommand(ApplicationUser user, IndexRecoveryService indexRecoveryService, JohnsonProvider johnsonProvider, Logger log, I18nHelper i18nHelper, String recoveryFilename) {
        this.user = user;
        this.indexRecoveryService = indexRecoveryService;
        this.johnsonProvider = johnsonProvider;
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.recoveryFilename = recoveryFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() throws Exception {
        JiraJohnsonContainer johnsonContainer = this.johnsonProvider.getContainer();
        Event appEvent = new Event(EventType.get((String)"reindex"), this.i18nHelper.getText(RECOVERY_MESSAGE), EventLevel.get((String)"warning"));
        johnsonContainer.addEvent(appEvent);
        try {
            Context context = Contexts.builder().sized((Sized)this.indexRecoveryService).event(appEvent).progress(this.taskProgressSink, this.i18nHelper, REINDEX_PERCENT, REINDEX_CURRENT).log(this.log, "Index Recovery: {0}%").build();
            this.log.info((Object)"Re-indexing started");
            IndexCommandResult indexCommandResult = this.indexRecoveryService.recoverIndexFromBackup(this.user, context, this.i18nHelper, this.recoveryFilename, this.taskProgressSink);
            return indexCommandResult;
        }
        finally {
            johnsonContainer.removeEvent(appEvent);
            this.log.info((Object)"Index Recovery finished");
        }
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }
}

