/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.core.ManagedClusterLock;
import com.atlassian.beehive.core.ManagedClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.operations.OpInstrument;
import com.atlassian.jira.cache.ManagedCacheInstruments;
import com.atlassian.jira.cluster.lock.ClusterLockInstruments;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ClassNameAbbreviator;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

@WebSudoRequired
@SystemAdminOnly
public class ViewInstrumentation
extends JiraWebActionSupport {
    private final CacheManager cacheManager;
    private final ClusterLockService clusterLockService;
    private final ClassNameAbbreviator classNameAbbreviator = ClassNameAbbreviator.DEFAULT;
    private Collection<InstrumentDisplayBean> displayBeanList;
    private boolean threadContentionMonitoring = false;

    public ViewInstrumentation(CacheManager cacheManager, ClusterLockService clusterLockService) {
        this.cacheManager = cacheManager;
        this.clusterLockService = clusterLockService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (ActionContext.getParameters().get("threadContentionMonitoring") != null) {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                threadMXBean.setThreadContentionMonitoringEnabled(this.threadContentionMonitoring);
            }
            if (threadMXBean.isThreadCpuTimeSupported()) {
                threadMXBean.setThreadCpuTimeEnabled(this.threadContentionMonitoring);
            }
        }
        return "success";
    }

    public Collection<InstrumentDisplayBean> getInstruments() {
        if (this.displayBeanList == null) {
            SortedSet<Instrument> sortedInstruments = this.getSortedInstruments();
            this.displayBeanList = Collections2.transform(sortedInstruments, (Function)new Function<Instrument, InstrumentDisplayBean>(){

                public InstrumentDisplayBean apply(@Nullable Instrument instrument) {
                    return new InstrumentDisplayBean(instrument);
                }
            });
        }
        return this.displayBeanList;
    }

    private SortedSet<Instrument> getSortedInstruments() {
        TreeSet sortedInstruments = Sets.newTreeSet((Comparator)new Comparator<Instrument>(){

            @Override
            public int compare(Instrument in1, Instrument in2) {
                return in1.getName().compareTo(in2.getName());
            }
        });
        ViewInstrumentation.collectBasicInstruments(sortedInstruments);
        this.collectCacheInstruments(sortedInstruments);
        this.collectClusterLockInstruments(sortedInstruments);
        return sortedInstruments;
    }

    private static boolean collectBasicInstruments(SortedSet<Instrument> sortedInstruments) {
        return sortedInstruments.addAll(Instrumentation.snapshotInstruments());
    }

    private void collectCacheInstruments(SortedSet<Instrument> sortedInstruments) {
        for (ManagedCache cache : this.cacheManager.getManagedCaches()) {
            sortedInstruments.addAll(new ManagedCacheInstruments(cache).getInstruments());
        }
    }

    private void collectClusterLockInstruments(SortedSet<Instrument> sortedInstruments) {
        if (this.clusterLockService instanceof ManagedClusterLockService) {
            ManagedClusterLockService mcls = (ManagedClusterLockService)this.clusterLockService;
            for (ManagedClusterLock clusterLock : mcls.getAllKnownClusterLocks()) {
                sortedInstruments.addAll(new ClusterLockInstruments(clusterLock).getInstruments());
            }
        } else {
            this.log.warn((Object)"Cluster lock service is not managed; no instrumentation is available");
        }
    }

    public JmxStateInfoDisplayBean getJmxStateInfo() {
        return new JmxStateInfoDisplayBean();
    }

    public void setThreadContentionMonitoring(boolean threadContentionMonitoring) {
        this.threadContentionMonitoring = threadContentionMonitoring;
    }

    public class JmxStateInfoDisplayBean {
        public boolean isThreadContentionMonitoringSupported() {
            return ManagementFactory.getThreadMXBean().isThreadContentionMonitoringSupported();
        }

        public boolean isThreadContentionMonitoringEnabled() {
            return ManagementFactory.getThreadMXBean().isThreadContentionMonitoringEnabled();
        }

        public boolean isThreadCpuTimeSupported() {
            return ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported();
        }

        public boolean isThreadCpuTimeEnabled() {
            return ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled();
        }
    }

    public class InstrumentDisplayBean {
        private final Instrument instrument;

        public InstrumentDisplayBean(Instrument instrument) {
            this.instrument = instrument;
        }

        public String getName() {
            return this.instrument.getName();
        }

        public String getAbbreviatedName() {
            return ViewInstrumentation.this.classNameAbbreviator.getAbbreviatedName(this.instrument.getName());
        }

        public String getType() {
            if (this.instrument instanceof Counter) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.counter");
            }
            if (this.instrument instanceof Gauge) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.gauge");
            }
            if (this.instrument instanceof OpInstrument) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.operation");
            }
            return "Unknown";
        }

        public String getValue() {
            if (this.instrument instanceof OpInstrument) {
                return "";
            }
            return this.valueOf(this.instrument.getValue());
        }

        public String getInvocationCount() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getInvocationCount();
            }
            return this.valueOf(v);
        }

        public String getMillisecondsTaken() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getMillisecondsTaken();
            }
            return this.valueOf(v);
        }

        public String getCpuTime() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getCpuTime();
            }
            return this.valueOf(v);
        }

        public String getResultSetSize() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getResultSetSize();
            }
            return this.valueOf(v);
        }

        private String valueOf(long v) {
            if (v == -1L) {
                return "";
            }
            NumberFormat df = DecimalFormat.getNumberInstance(ViewInstrumentation.this.getLocale());
            return df.format(v);
        }
    }
}

