/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.jira.instrumentation.CacheStatistics;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.LogEntry;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.instrumentation.cache.CacheStatsAverager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Pair;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import webwork.action.ActionContext;

@WebSudoRequired
@SystemAdminOnly
public class ViewCacheDetails
extends JiraWebActionSupport {
    private final InstrumentationLogger instrumentationLogger;
    private final CacheManager cacheManager;
    private String name;
    private Predicate<LogEntry> cacheStatNotNull = logData -> logData.getData().get("cache") != null;

    public ViewCacheDetails(CacheManager cacheManager, InstrumentationLogger instrumentationLogger) {
        this.cacheManager = cacheManager;
        this.instrumentationLogger = instrumentationLogger;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public Collection<CacheStatsAverager> getCacheDetails() {
        this.name = ActionContext.getSingleValueParameters().getOrDefault("name", "com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore.entries");
        List<LogEntry> stats = this.instrumentationLogger.getLogEntriesFromBuffer();
        Map<String, Long> urlCounts = stats.stream().filter(this.cacheStatNotNull.and(logData -> logData.getData().get("cache").stream().anyMatch(s -> s.getName().equals(this.name)))).collect(Collectors.groupingBy(LogEntry::getPath, Collectors.counting()));
        return stats.stream().filter(this.cacheStatNotNull).flatMap(logData -> logData.getData().get("cache").stream().filter(stat -> stat.getName().equals(this.name) && stat instanceof CacheStatistics).map(stat -> Pair.pair((Object)logData.getPath(), (Object)((CacheStatistics)stat)))).map(stat -> CacheStatsAverager.build((String)stat.left(), (CacheStatistics)stat.right())).collect(Collectors.groupingBy(CacheStatsAverager::getName, Collectors.collectingAndThen(Collectors.reducing((a, b) -> a.addAndSetCount((CacheStatsAverager)b, urlCounts.containsKey(a.getName()) ? (Long)urlCounts.get(a.getName()) : 0L)), Optional::get))).values();
    }

    public String getCacheEntryCount() {
        String name = (String)ActionContext.getSingleValueParameters().get("name");
        if (name == null) {
            return "0";
        }
        ManagedCache cache = this.cacheManager.getManagedCache(name);
        if (cache != null) {
            return String.valueOf(cache.getCacheCollector().getCacheSize());
        }
        return "0";
    }

    public String getRequestCount() {
        String name = ActionContext.getSingleValueParameters().getOrDefault("name", "com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore.entries");
        List<LogEntry> cacheRequestInfo = this.instrumentationLogger.getLogEntriesFromBuffer();
        return String.valueOf(cacheRequestInfo.stream().filter(this.cacheStatNotNull.and(logData -> logData.getData().get("cache").stream().anyMatch(s -> s.getName().equals(name)))).count());
    }

    public String getTotalLoadTime() {
        DecimalFormat formatter = new DecimalFormat("#.00");
        String name = (String)ActionContext.getSingleValueParameters().get("name");
        return String.valueOf(formatter.format(this.instrumentationLogger.getLogEntriesFromBuffer().stream().filter(this.cacheStatNotNull.and(logData -> logData.getData().get("cache").stream().anyMatch(s -> s.getName().equals(name)))).flatMap(logData -> logData.getData().get("cache").stream()).filter(stat -> stat instanceof CacheStatistics).map(stat -> (CacheStatistics)stat).mapToDouble(CacheStatistics::loadTime).sum()));
    }

    public String getName() {
        return this.name;
    }
}

