/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.instrumentation.caches.CacheKeys;
import com.atlassian.jira.instrumentation.CacheStatistics;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.instrumentation.cache.CacheDisplayBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@WebSudoRequired
@SystemAdminOnly
public class ViewCacheStats
extends JiraWebActionSupport {
    private final InstrumentationLogger instrumentationLogger;

    public ViewCacheStats(InstrumentationLogger instrumentationLogger) {
        this.instrumentationLogger = instrumentationLogger;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @Nonnull
    public Collection<CacheDisplayBean> getCacheStats() {
        return this.instrumentationLogger.getLogEntriesFromBuffer().stream().filter(logEntry -> logEntry.getData().get("cache") != null).flatMap(logEntry -> logEntry.getData().get("cache").stream()).filter(s -> s instanceof CacheStatistics).map(s -> (CacheStatistics)s).map(statistic -> {
            CacheDisplayBean bean = new CacheDisplayBean(statistic.getName(), statistic.type());
            this.fillOutStats((CacheStatistics)statistic, bean);
            bean.setName(statistic.getName());
            if (bean.getSize() == -1L) {
                bean.setSize(0L);
            }
            return bean;
        }).collect(Collectors.groupingByConcurrent(CacheDisplayBean::getName, Collectors.collectingAndThen(Collectors.reducing(CacheDisplayBean::add), Optional::get))).values();
    }

    private void fillOutStats(CacheStatistics st, CacheDisplayBean value) {
        value.setCacheType(st.type());
        value.setHitCount(st.hits());
        value.setMissCount(st.misses());
        value.setAvgLoadTime(st.loadTime());
        if (st.getStatsMap().containsKey(CacheKeys.PUTS.getName())) {
            value.setPutCount((Long)st.getStatsMap().get(CacheKeys.PUTS.getName()));
        }
        if (st.getStatsMap().containsKey(CacheKeys.LOADS.getName())) {
            value.setLoads((Long)st.getStatsMap().get(CacheKeys.LOADS.getName()));
        }
        if (st.getStatsMap().containsKey(CacheKeys.COUNT.getName())) {
            value.setSize((Long)st.getStatsMap().get(CacheKeys.COUNT.getName()));
        }
    }
}

