/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.jira.instrumentation.CacheStatistics;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.LogEntry;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.instrumentation.cache.CacheStatsAverager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import webwork.action.ActionContext;

@WebSudoRequired
@SystemAdminOnly
public class ViewCachesByRequest
extends JiraWebActionSupport {
    private String req;
    private final InstrumentationLogger instrumentationLogger;

    public ViewCachesByRequest(InstrumentationLogger instrumentationLogger) {
        this.instrumentationLogger = instrumentationLogger;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public List<CacheRequestBean> getRequestStats() {
        this.req = ActionContext.getSingleValueParameters().getOrDefault("r", "/admin/login.jsp");
        List<LogEntry> cacheRequestInfo = this.instrumentationLogger.getLogEntriesFromBuffer();
        long count = cacheRequestInfo.stream().filter(l -> l.getData().size() > 0 && l.getPath().equals(this.req)).count();
        CopyOnWriteArrayList<CacheRequestBean> result = new CopyOnWriteArrayList<CacheRequestBean>();
        cacheRequestInfo.stream().filter(logEntry -> logEntry.getData().get("cache") != null && logEntry.getPath().equals(this.req)).flatMap(l -> l.getData().get("cache").stream()).filter(stat -> stat instanceof CacheStatistics).map(stat -> CacheStatsAverager.build(stat.getName(), (CacheStatistics)stat)).collect(Collectors.groupingBy(CacheStatsAverager::getName, Collectors.collectingAndThen(Collectors.reducing((a, b) -> a.addAndSetCount((CacheStatsAverager)b, count)), Optional::get))).forEach((name, statsAverager) -> result.add(new CacheRequestBean((String)name, statsAverager.getAverageHits(), statsAverager.getAveragePuts(), statsAverager.getAverageMisses(), statsAverager.getAverageRemoves(), statsAverager.getAverageLoads(), statsAverager.getAverageLoadTime())));
        return result;
    }

    public String getReq() {
        return this.req;
    }

    public class CacheRequestBean {
        private String name;
        private double hits;
        private double puts;
        private double misses;
        private double removes;
        private double loads;
        private double loadTime;

        public CacheRequestBean(String name, double hits, double puts, double misses, double removes, double loads, double loadTime) {
            this.name = name;
            this.hits = hits;
            this.misses = misses;
            this.puts = puts;
            this.removes = removes;
            this.loads = loads;
            this.loadTime = loadTime;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getHits() {
            return this.hits;
        }

        public double getPuts() {
            return this.puts;
        }

        public double getMisses() {
            return this.misses;
        }

        public double getRemoves() {
            return this.removes;
        }

        public double getLoads() {
            return this.loads;
        }

        public double getLoadTime() {
            return this.loadTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheRequestBean)) {
                return false;
            }
            CacheRequestBean r = (CacheRequestBean)o;
            return r.getName().equals(this.getName());
        }
    }
}

