/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractEditFieldLayoutItem
extends JiraWebActionSupport {
    private Integer position;
    private String description;
    private String fieldName;
    private String fieldId;
    protected static final String ACCESS_EXCEPTION = "Error while accessing field layouts.";
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final FieldManager fieldManager;
    private ManagedConfigurationItem managedCustomField;
    private FieldLayoutItem fieldLayoutItem;

    protected AbstractEditFieldLayoutItem(ManagedConfigurationItemService managedConfigurationItemService, FieldManager fieldManager) {
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.fieldManager = fieldManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem();
        if (fieldLayoutItem != null) {
            if (this.isFieldLocked()) {
                this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", fieldLayoutItem.getOrderableField().getName()), ErrorCollection.Reason.FORBIDDEN);
                return "error";
            }
            this.setDescription(fieldLayoutItem.getRawFieldDescription());
            if (this.fieldManager.isCustomField((Field)fieldLayoutItem.getOrderableField())) {
                CustomField customField = this.fieldManager.getCustomField(fieldLayoutItem.getOrderableField().getId());
                this.setFieldName(customField.getName());
            } else {
                this.setFieldName(fieldLayoutItem.getOrderableField().getName());
            }
            return super.doDefault();
        }
        return "error";
    }

    protected void doValidation() {
        FieldLayoutItem fieldLayoutItem1 = this.getFieldLayoutItem();
        if (this.hasAnyErrors()) {
            return;
        }
        if (this.isFieldLocked() && fieldLayoutItem1 != null) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", fieldLayoutItem1.getOrderableField().getName()), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem();
        if (fieldLayoutItem != null) {
            this.getFieldLayout().setDescription(fieldLayoutItem, this.getDescription());
            this.store();
        }
        return this.getRedirect(this.getRedirectURI());
    }

    protected abstract String getRedirectURI();

    private FieldLayoutItem getFieldLayoutItem() {
        if (this.fieldLayoutItem != null) {
            return this.fieldLayoutItem;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fieldId)) {
            ArrayList fieldLayoutItems = new ArrayList(this.getFieldLayout().getFieldLayoutItems());
            this.fieldLayoutItem = fieldLayoutItems.stream().filter(fieldLayoutItem1 -> fieldLayoutItem1.getOrderableField().getId().equals(this.fieldId)).findFirst().orElse(null);
        } else if (this.getPosition() != null) {
            ArrayList fieldLayoutItems = new ArrayList(this.getFieldLayout().getFieldLayoutItems());
            Collections.sort(fieldLayoutItems);
            if (this.getPosition() >= 0 && this.getPosition() < fieldLayoutItems.size()) {
                this.fieldLayoutItem = (FieldLayoutItem)fieldLayoutItems.get(this.getPosition());
            } else {
                this.log.error((Object)("The field layout item at position '" + this.getPosition() + "' does not exist."));
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.field.does.not.exist", "'" + this.getPosition() + "'"));
            }
        }
        return this.fieldLayoutItem;
    }

    private void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    protected abstract EditableFieldLayout getFieldLayout();

    protected abstract void store();

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isFieldLocked() {
        ManagedConfigurationItem item = this.getManagedCustomField();
        if (item == null || !item.isManaged()) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), item);
    }

    private ManagedConfigurationItem getManagedCustomField() {
        if (this.managedCustomField != null) {
            return this.managedCustomField;
        }
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem();
        if (fieldLayoutItem == null) {
            return null;
        }
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (field == null) {
            return null;
        }
        if (field instanceof CustomField) {
            CustomField customField = (CustomField)field;
            this.managedCustomField = this.managedConfigurationItemService.getManagedCustomField(customField);
        }
        return this.managedCustomField;
    }
}

