/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class EditFieldLayoutItemRendererConfirmation
extends JiraWebActionSupport {
    private boolean confirmed = false;
    private String selectedRendererType;
    private String fieldName;
    private Integer rendererEdit;
    private Long id;
    private RendererManager rendererManager;
    private String fieldId;

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public EditFieldLayoutItemRendererConfirmation(RendererManager rendererManager) {
        this.rendererManager = rendererManager;
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doDefault() {
        return "success";
    }

    public String getCancelUrl() {
        if (this.getId() != null) {
            return "ConfigureFieldLayout!default.jspa?id=" + this.getId();
        }
        return "ViewIssueFields.jspa";
    }

    public String getSelectedRendererType() {
        return this.selectedRendererType;
    }

    public void setSelectedRendererType(String selectedRendererType) {
        this.selectedRendererType = selectedRendererType;
    }

    public Integer getRendererEdit() {
        return this.rendererEdit;
    }

    public void setRendererEdit(Integer rendererEdit) {
        this.rendererEdit = rendererEdit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getRendererDisplayName(String rendererType) {
        HackyRendererType hackyRendererType = HackyRendererType.fromKey((String)rendererType);
        if (hackyRendererType != null) {
            return this.getText(hackyRendererType.getDisplayNameI18nKey());
        }
        return this.rendererManager.getRendererForType(rendererType).getDescriptor().getName();
    }
}

