/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class AddFieldConfiguration
extends JiraWebActionSupport {
    private String fieldLayoutName;
    private String fieldLayoutDescription;
    private final FieldLayoutManager fieldLayoutManager;
    private List<EditableFieldLayout> editableFieldLayouts;

    public AddFieldConfiguration(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getFieldLayoutName())) {
            this.addError("fieldLayoutName", this.getText("admin.errors.empty.field.configuration.name"));
            return "error";
        }
        if (!this.invalidInput()) {
            for (FieldLayout fieldLayout : this.getFieldLayouts()) {
                if (!this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                return "error";
            }
        }
        EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        EditableFieldLayoutImpl editableFieldLayoutImpl = new EditableFieldLayoutImpl(null, editableDefaultFieldLayout.getFieldLayoutItems());
        editableFieldLayoutImpl.setName(this.getFieldLayoutName());
        editableFieldLayoutImpl.setDescription(this.getFieldLayoutDescription());
        EditableFieldLayout newLayout = this.fieldLayoutManager.storeAndReturnEditableFieldLayout((EditableFieldLayout)editableFieldLayoutImpl);
        return this.returnCompleteWithInlineRedirect(String.format("ConfigureFieldLayout!default.jspa?id=%d", newLayout.getId()));
    }

    public List<EditableFieldLayout> getFieldLayouts() {
        if (this.editableFieldLayouts == null) {
            this.editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        }
        return this.editableFieldLayouts;
    }

    public String getFieldLayoutName() {
        return this.fieldLayoutName;
    }

    public void setFieldLayoutName(String fieldLayoutName) {
        this.fieldLayoutName = fieldLayoutName;
    }

    public String getFieldLayoutDescription() {
        return this.fieldLayoutDescription;
    }

    public void setFieldLayoutDescription(String fieldLayoutDescription) {
        this.fieldLayoutDescription = fieldLayoutDescription;
    }
}

