/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.configuration.schemes;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class AddFieldConfigurationScheme
extends JiraWebActionSupport {
    private String fieldLayoutSchemeName;
    private String fieldLayoutSchemeDescription;
    private final FieldLayoutManager fieldLayoutManager;

    public AddFieldConfigurationScheme(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getFieldLayoutSchemeName())) {
            this.addError("fieldLayoutSchemeName", this.getText("admin.errors.empty.field.configuration.scheme.name"));
            return "error";
        }
        if (this.fieldLayoutManager.fieldConfigurationSchemeExists(this.getFieldLayoutSchemeName())) {
            this.addError("fieldLayoutSchemeName", this.getText("admin.errors.fieldlayout.scheme.name.exists"));
            return "error";
        }
        FieldLayoutScheme fieldLayoutScheme = this.fieldLayoutManager.createFieldLayoutScheme(this.getFieldLayoutSchemeName(), this.getFieldLayoutSchemeDescription());
        return this.returnCompleteWithInlineRedirect(String.format("ConfigureFieldLayoutScheme!default.jspa?id=%d", fieldLayoutScheme.getId()));
    }

    public String getFieldLayoutSchemeName() {
        return this.fieldLayoutSchemeName;
    }

    public void setFieldLayoutSchemeName(String fieldLayoutSchemeName) {
        this.fieldLayoutSchemeName = fieldLayoutSchemeName;
    }

    public String getFieldLayoutSchemeDescription() {
        return this.fieldLayoutSchemeDescription;
    }

    public void setFieldLayoutSchemeDescription(String fieldLayoutSchemeDescription) {
        this.fieldLayoutSchemeDescription = fieldLayoutSchemeDescription;
    }
}

