/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.configuration.schemes;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@WebSudoRequired
@AdminOnly
public class AddIssueTypeToFieldConfigurationAssociation
extends JiraWebActionSupport {
    private String issueTypeId;
    private Long id;
    private Long fieldConfigurationId;
    private FieldLayoutScheme fieldLayoutScheme;
    private List<IssueType> addableIssueTypes;
    private Collection<IssueType> allRelevantIssueTypeObjects;
    private List<EditableFieldLayout> editableFieldLayouts;
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldLayoutSchemeHelper fieldLayoutSchemeHelper;
    private final ReindexMessageManager reindexMessageManager;
    private final SubTaskManager subTaskManager;

    public AddIssueTypeToFieldConfigurationAssociation(FieldLayoutManager fieldLayoutManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, ReindexMessageManager reindexMessageManager, SubTaskManager subTaskManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldLayoutSchemeHelper = fieldLayoutSchemeHelper;
        this.reindexMessageManager = reindexMessageManager;
        this.subTaskManager = subTaskManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    protected void doValidation() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.required"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getIssueTypeId() == null) {
            this.addError("issueTypeId", this.getText("admin.errors.fieldlayoutscheme.no.issue.type"));
        }
        if (!this.invalidInput()) {
            this.fieldLayoutManager.createFieldLayoutSchemeEntity(this.getFieldLayoutScheme(), this.getIssueTypeId(), this.getFieldConfigurationId());
            if (this.isReindexRequired()) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.field.configuration");
            }
            return this.returnComplete("ConfigureFieldLayoutScheme.jspa?id=" + this.getId());
        }
        return this.getResult();
    }

    private boolean isReindexRequired() {
        Long unmappedLayoutId = this.getFieldLayoutScheme().getFieldLayoutId(null);
        return this.fieldLayoutSchemeHelper.doesChangingFieldLayoutAssociationRequireMessage(this.getLoggedInUser(), this.getFieldLayoutScheme(), unmappedLayoutId, this.getFieldConfigurationId());
    }

    public FieldLayoutScheme getFieldLayoutScheme() {
        if (this.fieldLayoutScheme == null) {
            this.fieldLayoutScheme = this.fieldLayoutManager.getMutableFieldLayoutScheme(this.getId());
        }
        return this.fieldLayoutScheme;
    }

    public Collection<IssueType> getAddableIssueTypes() {
        if (this.addableIssueTypes == null) {
            this.addableIssueTypes = new LinkedList<IssueType>(this.getAllRelevantIssueTypeObjects());
            Iterator<IssueType> iterator = this.addableIssueTypes.iterator();
            while (iterator.hasNext()) {
                IssueType issueType = iterator.next();
                if (this.getFieldLayoutScheme().getEntity(issueType.getId()) == null) continue;
                iterator.remove();
            }
        }
        return this.addableIssueTypes;
    }

    public Collection<EditableFieldLayout> getFieldLayouts() {
        if (this.editableFieldLayouts == null) {
            this.editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        }
        return this.editableFieldLayouts;
    }

    private Collection<IssueType> getAllRelevantIssueTypeObjects() {
        if (this.allRelevantIssueTypeObjects == null) {
            this.allRelevantIssueTypeObjects = this.subTaskManager.isSubTasksEnabled() ? this.getConstantsManager().getAllIssueTypeObjects() : this.getConstantsManager().getRegularIssueTypeObjects();
        }
        return this.allRelevantIssueTypeObjects;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFieldLayoutId(EditableFieldLayout editableFieldLayout) {
        if (editableFieldLayout.getType() != null) {
            return "";
        }
        return editableFieldLayout.getId().toString();
    }

    public Long getFieldConfigurationId() {
        return this.fieldConfigurationId;
    }

    public void setFieldConfigurationId(Long fieldConfigurationId) {
        this.fieldConfigurationId = fieldConfigurationId;
    }
}

