/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;

public abstract class AbstractEditFieldLayoutSchemeAction
extends JiraWebActionSupport {
    private final FieldLayoutManager fieldLayoutManager;
    private Long id;
    private String fieldLayoutSchemeName;
    private String fieldLayoutSchemeDescription;
    private FieldLayoutScheme fieldLayoutScheme;
    private List<FieldLayoutScheme> fieldLayoutSchemes;

    public AbstractEditFieldLayoutSchemeAction(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    protected String redirectToView() {
        return this.getRedirect("ViewFieldLayoutSchemes.jspa");
    }

    protected Collection<FieldLayoutScheme> getFieldLayoutSchemes() {
        if (this.fieldLayoutSchemes == null) {
            this.fieldLayoutSchemes = this.fieldLayoutManager.getFieldLayoutSchemes();
        }
        return this.fieldLayoutSchemes;
    }

    protected void validateName() {
        if (!TextUtils.stringSet((String)this.getFieldLayoutSchemeName())) {
            this.addError("fieldLayoutSchemeName", this.getText("admin.common.errors.validname"));
        }
    }

    protected void validateFieldLayoutScheme() {
        if (this.getFieldLayoutScheme() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.id", "'" + this.getId() + "'"));
        }
    }

    public FieldLayoutScheme getFieldLayoutScheme() {
        if (this.fieldLayoutScheme == null) {
            this.fieldLayoutScheme = this.fieldLayoutManager.getMutableFieldLayoutScheme(this.getId());
        }
        return this.fieldLayoutScheme;
    }

    protected void validateId() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.required"));
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFieldLayoutSchemeName() {
        return this.fieldLayoutSchemeName;
    }

    public void setFieldLayoutSchemeName(String fieldLayoutSchemeName) {
        this.fieldLayoutSchemeName = fieldLayoutSchemeName;
    }

    public String getFieldLayoutSchemeDescription() {
        return this.fieldLayoutSchemeDescription;
    }

    public void setFieldLayoutSchemeDescription(String fieldLayoutSchemeDescription) {
        this.fieldLayoutSchemeDescription = fieldLayoutSchemeDescription;
    }

    public Collection getSchemeProjects(FieldLayoutScheme fieldLayoutScheme) {
        return this.fieldLayoutManager.getProjects(fieldLayoutScheme);
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayoutScheme();
            if (!this.invalidInput()) {
                this.setFieldLayoutSchemeName(this.getInitialName());
                this.setFieldLayoutSchemeDescription(this.getFieldLayoutScheme().getDescription());
            }
        }
        return "input";
    }

    protected abstract String getInitialName();
}

