/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;

abstract class AbstractFieldLayoutAction
extends JiraWebActionSupport {
    private final FieldLayoutManager fieldLayoutManager;
    private Long id;
    private String fieldLayoutName;
    private String fieldLayoutDescription;
    private List<EditableFieldLayout> editableFieldLayouts;
    private EditableFieldLayout editableFieldLayout;

    AbstractFieldLayoutAction(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public Collection<EditableFieldLayout> getFieldLayouts() {
        if (this.editableFieldLayouts == null) {
            this.editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        }
        return this.editableFieldLayouts;
    }

    protected String redirectToView() {
        return this.getRedirect("ViewFieldLayouts.jspa");
    }

    public String getFieldLayoutName() {
        return this.fieldLayoutName;
    }

    public void setFieldLayoutName(String fieldLayoutName) {
        this.fieldLayoutName = fieldLayoutName;
    }

    public String getFieldLayoutDescription() {
        return this.fieldLayoutDescription;
    }

    public void setFieldLayoutDescription(String fieldLayoutDescription) {
        this.fieldLayoutDescription = fieldLayoutDescription;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EditableFieldLayout getFieldLayout() {
        if (this.editableFieldLayout == null) {
            this.editableFieldLayout = this.getFieldLayoutManager().getEditableFieldLayout(this.getId());
        }
        return this.editableFieldLayout;
    }

    protected void validateId() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.required"));
        }
    }

    protected void validateFieldLayout() {
        if (this.getFieldLayout() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.field.config.id", "'" + this.getId() + "'"));
        }
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    protected void validateName() {
        if (!TextUtils.stringSet((String)this.getFieldLayoutName())) {
            this.addError("fieldLayoutName", this.getText("admin.common.errors.validname"));
        }
    }
}

