/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.admin.issuefields.AbstractConfigureFieldLayout;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import java.util.List;

@WebSudoRequired
@AdminOnly
public class ConfigureFieldLayout
extends AbstractConfigureFieldLayout {
    private EditableFieldLayout editableSchemeFieldLayout = null;
    private FieldLayout schemeFieldLayout = null;
    private ProjectFieldLayoutSchemeHelper helper;
    private List<Project> projects;

    public ConfigureFieldLayout(FieldScreenManager fieldScreenManager, RendererManager rendererManager, ReindexMessageManager reindexMessageManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, HackyFieldRendererRegistry hackyFieldRendererRegistry, ProjectFieldLayoutSchemeHelper helper, ManagedConfigurationItemService managedConfigurationItemService, PageBuilderService pageBuilderService) {
        super(fieldScreenManager, rendererManager, reindexMessageManager, fieldLayoutSchemeHelper, fieldManager, fieldLayoutManager, hackyFieldRendererRegistry, managedConfigurationItemService, pageBuilderService);
        this.helper = helper;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.requireFieldConfigurationPanel();
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.requireFieldConfigurationPanel();
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getId() != null) {
            if (this.getFieldLayout() == null) {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.field.config.id", "'" + this.getId() + "'"));
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.no.layout.specified"));
        }
    }

    @Override
    public EditableFieldLayout getFieldLayout() {
        if (this.editableSchemeFieldLayout == null) {
            this.editableSchemeFieldLayout = this.getFieldLayoutManager().getEditableFieldLayout(this.getId());
        }
        return this.editableSchemeFieldLayout;
    }

    @Override
    protected String getFieldRedirect() throws Exception {
        return this.getRedirect("ConfigureFieldLayout!default.jspa?id=" + this.getId());
    }

    @Override
    protected void store() {
        try {
            this.getFieldLayoutManager().storeEditableFieldLayout(this.getFieldLayout());
        }
        catch (DataAccessException ex) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.error.storing"));
        }
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldLayout fieldLayout = this.getNonEditableFieldLayout();
            this.projects = this.helper.getProjectsForFieldLayout(fieldLayout);
        }
        return this.projects;
    }

    private FieldLayout getNonEditableFieldLayout() {
        if (this.schemeFieldLayout == null) {
            this.schemeFieldLayout = this.getFieldLayoutManager().getFieldLayout(this.getId());
        }
        return this.schemeFieldLayout;
    }

    private void requireFieldConfigurationPanel() {
        this.getPageBuilderService().assembler().resources().requireContext(ResourcePhase.DEFER, "fieldConfigurationPanel");
    }
}

