/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractEditFieldLayoutSchemeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class CopyFieldLayoutScheme
extends AbstractEditFieldLayoutSchemeAction {
    public CopyFieldLayoutScheme(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    protected void doValidation() {
        this.validateName();
        if (!this.invalidInput()) {
            this.validateId();
            if (!this.invalidInput()) {
                for (FieldLayoutScheme fieldLayoutScheme : this.getFieldLayoutSchemes()) {
                    if (!this.getFieldLayoutSchemeName().equals(fieldLayoutScheme.getName())) continue;
                    this.addError("fieldLayoutSchemeName", this.getText("admin.errors.fieldlayout.scheme.name.exists"));
                }
                if (!this.invalidInput()) {
                    this.validateFieldLayoutScheme();
                }
            }
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.getFieldLayoutManager().copyFieldLayoutScheme(this.getFieldLayoutScheme(), this.getFieldLayoutSchemeName(), this.getFieldLayoutSchemeDescription());
        return this.redirectToView();
    }

    @Override
    protected String getInitialName() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", this.getFieldLayoutScheme().getName());
    }
}

