/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.auditing.handlers.FieldScreenSchemeHandler;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@WebSudoRequired
@AdminOnly
public class ViewFieldScreenSchemes
extends AbstractFieldScreenSchemeAction {
    private String confirm;
    private Map issueTypeScreenSchemeMap;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenManager fieldScreenManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Collection fieldScreens;
    private Long fieldScreenId;
    private final FieldScreenSchemeHandler fieldScreenSchemeHandler;

    public ViewFieldScreenSchemes(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenFactory fieldScreenFactory, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager, FieldScreenSchemeHandler fieldScreenSchemeHandler) {
        super(fieldScreenSchemeManager);
        this.fieldScreenFactory = fieldScreenFactory;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenSchemeHandler = fieldScreenSchemeHandler;
        this.issueTypeScreenSchemeMap = new HashMap();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAddNewFieldScreenScheme() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddFieldScreenScheme() {
        this.validateName(false);
        if (!this.invalidInput()) {
            FieldScreenScheme fieldScreenScheme = this.fieldScreenFactory.createFieldScreenScheme();
            fieldScreenScheme.setName(this.getFieldScreenSchemeName());
            fieldScreenScheme.setDescription(this.getFieldScreenSchemeDescription());
            fieldScreenScheme.store();
            FieldScreenSchemeItem fieldScreenSchemeItem = this.fieldScreenFactory.createFieldScreenSchemeItem();
            fieldScreenSchemeItem.setIssueOperation(null);
            fieldScreenSchemeItem.setFieldScreen(this.fieldScreenManager.getFieldScreen(this.getFieldScreenId()));
            fieldScreenScheme.addFieldScreenSchemeItem(fieldScreenSchemeItem);
            this.fieldScreenSchemeHandler.handleFieldScreenSchemeCreated(fieldScreenScheme, fieldScreenSchemeItem);
            return this.returnCompleteWithInlineRedirect("ConfigureFieldScreenScheme.jspa?id=" + fieldScreenScheme.getId());
        }
        return "error";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doDeleteFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            Collection fieldScreenSchemeItems = fieldScreenScheme.getFieldScreenSchemeItems();
            fieldScreenScheme.remove();
            this.fieldScreenSchemeHandler.handleFieldScreenSchemeDeleted(fieldScreenScheme, fieldScreenSchemeItems);
            return this.redirectToView();
        }
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doViewDeleteFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            return "confirm";
        }
        return this.getResult();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Collection getIssueTypeScreenSchemes(FieldScreenScheme fieldScreenScheme) {
        if (!this.issueTypeScreenSchemeMap.containsKey(fieldScreenScheme.getId())) {
            this.issueTypeScreenSchemeMap.put(fieldScreenScheme.getId(), this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes(fieldScreenScheme));
        }
        return (Collection)this.issueTypeScreenSchemeMap.get(fieldScreenScheme.getId());
    }

    public Collection getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    public void setFieldScreenId(Long fieldScreenId) {
        this.fieldScreenId = fieldScreenId;
    }
}

