/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenOperationContext;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.JiraStringUtils;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@WebSudoRequired
@AdminOnly
public class ViewFieldScreens
extends AbstractFieldScreenAction {
    private String confirm;
    private Map fieldScreenSchemeMap;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final WorkflowManager workflowManager;
    private final FieldScreenService fieldScreenService;
    private final PageBuilderService pageBuilderService;
    private List<JiraWorkflow> workflowsIncludingDrafts;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ViewFieldScreens(FieldScreenManager fieldScreenManager, FieldScreenFactory fieldScreenFactory, FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenService fieldScreenService, WorkflowManager workflowManager, JiraAuthenticationContext jiraAuthenticationContext, PageBuilderService pageBuilderService) {
        super(fieldScreenManager);
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.fieldScreenService = fieldScreenService;
        this.workflowManager = workflowManager;
        this.pageBuilderService = pageBuilderService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldScreenSchemeMap = new HashMap();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.pageBuilderService.assembler().resources().requireContext("detailedScreensTable");
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAddNewFieldScreen() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddFieldScreen() {
        this.validateScreenName();
        if (!this.invalidInput()) {
            FieldScreen fieldScreen = this.fieldScreenFactory.createScreen();
            fieldScreen.setName(this.getFieldScreenName());
            fieldScreen.setDescription(this.getFieldScreenDescription());
            fieldScreen.store();
            fieldScreen.addTab(this.getText("admin.field.screen.default"));
            return this.returnCompleteWithInlineRedirect("ConfigureFieldScreen.jspa?id=" + fieldScreen.getId());
        }
        return "error";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doViewDeleteFieldScreen() {
        this.validateId();
        if (this.invalidInput()) {
            return this.getResult();
        }
        if (!this.isDeletable(this.getFieldScreen())) {
            this.addErrorMessage(this.getText("admin.errors.screens.cannot.delete.screen.used.screen.schemes"));
        }
        if (!TextUtils.stringSet((String)this.confirm)) {
            return "confirm";
        }
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doDeleteFieldScreen() {
        this.validateId();
        if (this.invalidInput()) {
            return this.getResult();
        }
        if (!this.isDeletable(this.getFieldScreen())) {
            this.addErrorMessage(this.getText("admin.errors.screens.cannot.delete.screen.used.screen.schemes"));
        }
        this.getFieldScreen().remove();
        return this.redirectToView();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Collection getFieldScreenSchemes(FieldScreen fieldScreen) {
        if (!this.fieldScreenSchemeMap.containsKey(fieldScreen.getId())) {
            this.fieldScreenSchemeMap.put(fieldScreen.getId(), this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        }
        return (Collection)this.fieldScreenSchemeMap.get(fieldScreen.getId());
    }

    public Map<JiraWorkflow, Collection<ActionDescriptor>> getWorkflows(FieldScreen fieldScreen) {
        TreeMap<JiraWorkflow, Collection<ActionDescriptor>> workflows = new TreeMap<JiraWorkflow, Collection<ActionDescriptor>>();
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            workflows.put(workflow, actions);
        }
        return workflows;
    }

    public Collection<WorkflowTransitionViewHelper> getWorkflowTransitionViews(FieldScreen fieldScreen) {
        ArrayList<WorkflowTransitionViewHelper> answer = new ArrayList<WorkflowTransitionViewHelper>();
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            for (ActionDescriptor action : actions) {
                answer.add(new WorkflowTransitionViewHelper(workflow, action));
            }
        }
        Collections.sort(answer);
        return answer;
    }

    private boolean hasWorkflowsIncludingDrafts(FieldScreen fieldScreen) {
        for (JiraWorkflow workflow : this.getWorkflowsIncludingDrafts()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private List<JiraWorkflow> getWorkflowsIncludingDrafts() {
        if (this.workflowsIncludingDrafts == null) {
            this.workflowsIncludingDrafts = this.workflowManager.getWorkflowsIncludingDrafts();
        }
        return this.workflowsIncludingDrafts;
    }

    public boolean isDeletable(FieldScreen fieldScreen) {
        return (Boolean)this.fieldScreenService.getIsFieldScreenDeletable(FieldScreenId.byId((long)fieldScreen.getId()), this.userContext()).get();
    }

    private FieldScreenOperationContext userContext() {
        return FieldScreenOperationContext.ofUser((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser());
    }

    public static class WorkflowTransitionViewHelper
    implements Comparable<WorkflowTransitionViewHelper> {
        private final JiraWorkflow workflow;
        private final ActionDescriptor transition;
        private final Collection<StepDescriptor> steps;

        private WorkflowTransitionViewHelper(JiraWorkflow workflow, ActionDescriptor transition) {
            this.workflow = workflow;
            this.transition = transition;
            this.steps = this.initTransitionSteps();
        }

        private Collection<StepDescriptor> initTransitionSteps() {
            return this.workflow.getStepsForTransition(this.transition);
        }

        @Override
        public int compareTo(WorkflowTransitionViewHelper other) {
            return this.workflow.compareTo((Object)other.workflow);
        }

        public String getWorkflowName() {
            return this.workflow.getName();
        }

        public String getWorkflowMode() {
            return this.workflow.getMode();
        }

        public String getTransitionName() {
            return this.transition.getName();
        }

        public int transitionId() {
            return this.transition.getId();
        }

        public boolean hasSteps() {
            return !this.steps.isEmpty();
        }

        public StepDescriptor getFirstStep() {
            if (!this.hasSteps()) {
                throw new IllegalStateException("No steps for " + this);
            }
            return this.steps.iterator().next();
        }

        public boolean isGlobalAction() {
            return this.workflow.isGlobalAction(this.transition);
        }

        public String toString() {
            return JiraStringUtils.asString((Object[])new Object[]{"WorkflowTransition[Workflow=", this.workflow.getName(), ",transition=", this.transition.getId(), "]"});
        }
    }
}

