/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
@AdminOnly
public class DeleteIssueSecurityLevel
extends SchemeAwareIssueSecurityAction {
    private List<GenericValue> affectedIssues;
    private Long levelId;
    private Long swapLevel;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public DeleteIssueSecurityLevel(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        super(issueSecuritySchemeManager, issueSecurityTypeManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        GenericValue scheme;
        for (GenericValue issue : this.getAffectedIssues()) {
            issue.set("security", (Object)this.swapLevel);
            issue.store();
        }
        if (this.isDefault(this.levelId) && (scheme = this.getScheme()) != null) {
            scheme.set("defaultlevel", null);
            scheme.store();
        }
        ((IssueIndexManager)ComponentAccessor.getComponent(IssueIndexManager.class)).reIndexIssues(this.getAffectedIssues());
        this.issueSecurityLevelManager.deleteSecurityLevel(this.levelId);
        this.issueSecurityLevelManager.clearUsersLevels();
        return this.getRedirect(this.getRedirectURL());
    }

    public List<GenericValue> getAffectedIssues() {
        if (this.affectedIssues == null) {
            try {
                this.affectedIssues = ComponentAccessor.getOfBizDelegator().findByAnd("Issue", (Map)FieldMap.build((String)"security", (Object)this.levelId));
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
                return null;
            }
        }
        return this.affectedIssues;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public String getIssueSecurityName() throws GenericEntityException {
        return this.issueSecurityLevelManager.getIssueSecurityName(this.levelId);
    }

    @Override
    public String getRedirectURL() {
        return "EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId();
    }

    public Map getOtherLevels() {
        Object levels = new ListOrderedMap();
        try {
            List schemeIssueSecurities = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(this.getSchemeId());
            levels = JiraEntityUtils.createEntityMap(schemeIssueSecurities, "id", "name");
            levels.remove(this.levelId);
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.issuesecurity.exception.getting.versions"));
        }
        return levels;
    }

    public Long getSwapLevel() {
        return this.swapLevel;
    }

    public void setSwapLevel(Long swapLevel) {
        this.swapLevel = swapLevel == null || swapLevel.equals(new Long(-1L)) ? null : swapLevel;
    }
}

