/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeCommand;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeTaskContext;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.AbstractSelectProjectScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class SelectProjectIssueSecurityScheme
extends AbstractSelectProjectScheme {
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final TaskManager taskManager;
    private TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> currentTaskDescriptor;

    public SelectProjectIssueSecurityScheme(IssueSecuritySchemeManager issueSecuritySchemeManager, TaskManager taskManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.taskManager = taskManager;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return super.doDefault();
    }

    private TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new AssignIssueSecuritySchemeTaskContext(this.getProject()));
        }
        return this.currentTaskDescriptor;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.issueSecuritySchemeManager;
    }
}

