/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeTemplateProperties;
import com.atlassian.jira.web.action.issue.URLUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class EditIssueType
extends AbstractEditConstant<IssueType>
implements IssueTypeTemplateProperties {
    private final IssueTypeService issueTypeService;
    private Long avatarId;

    public EditIssueType(IssueTypeService issueTypeService) {
        this.issueTypeService = issueTypeService;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        IssueType constant = (IssueType)this.getConstant();
        if (null != constant) {
            this.avatarId = constant.getAvatar() != null ? constant.getAvatar().getId() : null;
        }
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        if (this.avatarId == null && StringUtils.isBlank((CharSequence)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.issuetypes.must.specify.url"));
        }
        super.doValidation();
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected IssueType getConstant(String id) {
        return this.getConstantsManager().getIssueType(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    protected Collection<IssueType> getConstants() {
        return this.getConstantsManager().getAllIssueTypeObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
    }

    @Override
    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    @Override
    @ActionViewData(key="issueType")
    public IssueTypeViewData getIssueTypeValue() {
        return new IssueTypeViewData();
    }

    @Override
    @ActionViewData
    public String getAction() {
        return "EditIssueType.jspa";
    }

    @Override
    @ActionViewData
    public String getCancelAction() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    @ActionViewData
    public String getActiveTab() {
        return "issue_types";
    }

    @Override
    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @Override
    @ActionViewData(key="errors")
    public Map<String, Object> getWrappedErrorsForView() {
        return MapBuilder.newBuilder().add((Object)"errors", (Object)super.getErrors()).toMap();
    }

    @Override
    @ActionViewData(key="errorMessages")
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @Override
    @ActionViewData
    public String getDefaultAvatarId() {
        return this.getApplicationProperties().getString("jira.avatar.issuetype.default.id");
    }

    @Override
    @ActionViewData
    public String getEditTitleTextId() {
        return this.getI18nHelper().getText("admin.issuesettings.issuetypes.edit.issue.type");
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        IssueTypeService.UpdateValidationResult validationResult = this.issueTypeService.validateUpdateIssueType(this.getLoggedInUser(), this.id, IssueTypeService.IssueTypeUpdateInput.builder().setAvatarId(this.avatarId).setName(this.name).setDescription(this.description).build());
        if (!validationResult.isValid()) {
            this.addErrorMessages(validationResult.getErrorCollection().getErrorMessages());
            return "error";
        }
        this.issueTypeService.updateIssueType(this.getLoggedInUser(), validationResult);
        return this.getRedirect(this.getRedirectPage());
    }

    public class IssueTypeViewData
    implements IssueTypeTemplateProperties.IssueTypeViewData {
        @Override
        public String getName() {
            return EditIssueType.this.getName();
        }

        @Override
        public String getNameTranslation() {
            return ((IssueType)EditIssueType.this.getConstant()).getNameTranslation();
        }

        @Override
        public String getDescription() {
            return EditIssueType.this.getDescription();
        }

        @Override
        public String getId() {
            return EditIssueType.this.getId();
        }

        @Override
        public Long getAvatarId() {
            return EditIssueType.this.getAvatarId();
        }

        @Override
        public String getIconUrlContent() {
            String iconurl = EditIssueType.this.getIconurl();
            String contextPath = EditIssueType.this.getHttpRequest().getContextPath();
            return URLUtil.addContextPathToURLIfAbsent(contextPath, iconurl);
        }
    }
}

