/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
@AdminOnly
public class ManageIssueTypeSchemes
extends AbstractManageIssueTypeOptionsAction {
    private final TranslationManager translationManager;

    public ManageIssueTypeSchemes(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, IssueManager issueManager, TranslationManager translationManager, IssueTypeSchemeService issueTypeSchemeService) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, issueManager, issueTypeSchemeService);
        this.translationManager = translationManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAddScheme() throws Exception {
        return "success";
    }

    public List<FieldConfigScheme> getSchemes() {
        ConfigurableField field = this.getConfigurableField();
        return this.configSchemeManager.getConfigSchemesForField(field);
    }

    public boolean isDefault(String id, FieldConfigScheme configScheme) {
        IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(configScheme.getOneAndOnlyConfig());
        return defaultValue != null && id.equals(defaultValue.getId());
    }

    public String getActionType() {
        return "scheme";
    }

    public Collection getOptions(FieldConfigScheme configScheme) {
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        return this.optionSetManager.getOptionsForConfig(config).getOptions();
    }

    public boolean isDefault(FieldConfigScheme configScheme) {
        return this.issueTypeSchemeManager.isDefaultIssueTypeScheme(configScheme);
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

