/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.notification;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.notification.ProjectNotificationsSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.template.Template;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.web.action.admin.notification.SchemeAwareNotificationAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
@AdminOnly
public class EditNotifications
extends SchemeAwareNotificationAction {
    private final ProjectNotificationsSchemeHelper helper;
    private List<Project> projects;

    public EditNotifications(ProjectNotificationsSchemeHelper helper) {
        this.helper = helper;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public Map<Long, EventType> getEvents() {
        return ComponentAccessor.getEventTypeManager().getEventTypesMap();
    }

    public List getNotifications(Long eventTypeId) throws GenericEntityException {
        return this.getSchemeManager().getEntities(this.getScheme(), eventTypeId);
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    public Template getTemplate(GenericValue notificationGV) {
        SchemeEntity notificationSchemeEntity = new SchemeEntity(notificationGV.getLong("id"), notificationGV.getString("type"), notificationGV.getString("parameter"), notificationGV.get("eventTypeId"), notificationGV.get("templateId"), notificationGV.getLong("scheme"));
        return this.getTemplateManager().getTemplate(notificationSchemeEntity);
    }

    public TemplateManager getTemplateManager() {
        return (TemplateManager)ComponentAccessor.getComponentOfType(TemplateManager.class);
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme notificationsScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(notificationsScheme);
        }
        return this.projects;
    }
}

