/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.PrioritySchemeHelper;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.priorities.ConfigurePriorityScheme;
import com.atlassian.jira.web.action.admin.priorities.PriorityManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Arrays;

@WebSudoRequired
@AdminOnly
public class AddPriorityScheme
extends ConfigurePriorityScheme {
    public AddPriorityScheme(FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, PriorityManageableOption priorityManageableOption, PrioritySchemeManager prioritySchemeManager, PriorityManager priorityManager, PageBuilderService pageBuilderService, PrioritySchemeService prioritySchemeService, I18nHelper i18nHelper, PrioritySchemeHelper prioritySchemeHelper) {
        super(configSchemeManager, fieldManager, priorityManageableOption, prioritySchemeManager, priorityManager, pageBuilderService, prioritySchemeService, i18nHelper, prioritySchemeHelper);
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ServiceOutcome<FieldConfigScheme> result = this.prioritySchemeService.createScheme(this.getLoggedInUser(), PrioritySchemeService.PrioritySchemeData.builder().name(this.name).description(this.description).priorityIds(Arrays.asList(this.selectedPriorities)).defaultPriorityId(this.defaultPriority).build());
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
        }
        return super.doExecute();
    }
}

