/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@AdminOnly
public class DeletePriority
extends AbstractDeleteConstant<Priority> {
    private final PriorityManager priorityManager;
    private final PrioritySchemeManager prioritySchemeManager;
    private final I18nHelper i18nHelper;
    private final FeatureManager featureManager;
    private final PageBuilderService pageBuilderService;
    private static final Logger log = LoggerFactory.getLogger(DeletePriority.class);
    private static final String NEW_ID_ERROR_KEY = "newId";

    public DeletePriority(PriorityManager priorityManager, PrioritySchemeManager prioritySchemeManager, I18nHelper i18nHelper, FeatureManager featureManager, PageBuilderService pageBuilderService) {
        this.priorityManager = priorityManager;
        this.prioritySchemeManager = prioritySchemeManager;
        this.i18nHelper = i18nHelper;
        this.featureManager = featureManager;
        this.pageBuilderService = pageBuilderService;
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:priority-delete");
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected Priority getConstant(String id) {
        return this.getConstantsManager().getPriorityObject(id);
    }

    public String getNewIdError() {
        return (String)this.getErrors().get(NEW_ID_ERROR_KEY);
    }

    public boolean isShowNextId() {
        try {
            return this.getMatchingIssues().size() != 0;
        }
        catch (GenericEntityException e) {
            log.error("Can't determine number of issues in priority which is going to be removed", (Throwable)e);
            return true;
        }
    }

    private String getNewIdOrDefault() {
        if (this.newId != null) {
            return this.newId;
        }
        return this.getConstants().stream().findFirst().map(IssueConstant::getId).orElse(null);
    }

    private Optional<Priority> getPriority() {
        return Optional.ofNullable((Priority)this.getConstant());
    }

    private Optional<String> escapedPriorityName() {
        return this.getPriority().map(IssueConstant::getName).map(name -> {
            try {
                return URLEncoder.encode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(MessageFormat.format("Can't escape priority name '{0}' with encoding 'UTF-8'", name), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    protected String getRedirectPage() {
        return this.escapedPriorityName().map(name -> MessageFormat.format("ViewPriorities.jspa?deletedPriorityName={0}", name)).orElse("ViewPriorities.jspa");
    }

    @Override
    protected Collection<Priority> getConstants() {
        Collection prioritySchemes;
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT) && (prioritySchemes = this.prioritySchemeManager.getAllRelatedSchemes(this.id)).size() == 1) {
            FieldConfigScheme priorityScheme = (FieldConfigScheme)prioritySchemes.iterator().next();
            FieldConfig fieldConfig = this.prioritySchemeManager.getFieldConfigForDefaultMapping(priorityScheme);
            return this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(fieldConfig));
        }
        return this.priorityManager.getPriorities();
    }

    private void validatePriorities() {
        if (this.hasAnyErrors()) {
            return;
        }
        if (!this.getPriority().isPresent()) {
            this.addErrorMessage(this.i18nHelper.getText("admin.issuesettings.priorities.delete.error.no.priority.or.null"));
            return;
        }
        Priority priority = this.getPriority().get();
        String safePriorityName = StringEscapeUtils.escapeHtml4((String)priority.getName());
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT)) {
            Collection prioritySchemes = this.prioritySchemeManager.getAllRelatedSchemes(this.id);
            if (prioritySchemes.size() > 1) {
                this.addErrorMessage(this.i18nHelper.getText("admin.issuesettings.priorities.delete.error.used.by.multiple.schemes", "<strong>", safePriorityName, "</strong>"));
                return;
            }
            if (prioritySchemes.size() == 1) {
                FieldConfigScheme priorityScheme = (FieldConfigScheme)prioritySchemes.iterator().next();
                FieldConfig fieldConfig = this.prioritySchemeManager.getFieldConfigForDefaultMapping(priorityScheme);
                if (this.prioritySchemeManager.getOptions(fieldConfig).size() <= 1) {
                    this.addErrorMessage(this.i18nHelper.getText("admin.issuesettings.priorities.delete.error.last.priority.in.scheme", "<strong>", safePriorityName, "</strong>"));
                }
                return;
            }
        }
        if (this.priorityManager.getPriorities().size() <= 1) {
            this.addErrorMessage(this.i18nHelper.getText("admin.issuesettings.priorities.delete.error.last.priority", "<strong>", safePriorityName, "</strong>"));
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.requireResources();
        this.validatePriorities();
        if (this.hasAnyErrors()) {
            return "error";
        }
        return super.doDefault();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    @Override
    protected void doValidation() {
        this.requireResources();
        this.validatePriorities();
        if (!this.hasAnyErrors()) {
            super.doValidation();
        }
    }

    @Override
    protected void validateNewId() {
        try {
            if (this.getMatchingIssues().size() == 0) {
                return;
            }
        }
        catch (GenericEntityException e) {
            log.error("Can't determine number of issues in priority which is going to be removed", (Throwable)e);
        }
        if (!this.isNewIdValid()) {
            this.addError(NEW_ID_ERROR_KEY, this.i18nHelper.getText("admin.issuesettings.priorities.delete.error.specify.id"));
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm && !this.hasAnyErrors()) {
            this.priorityManager.removePriority(this.id, this.getNewIdOrDefault());
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }
}

