/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.ProjectRoleUsageAction;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@WebSudoRequired
@OpenAPIDefinition
@Path(value="secure/project/DeleteProjectRole!default.jspa")
@Produces(value={"text/html"})
@Tag(name="webwork")
@AdminOnly
public class DeleteProjectRole
extends ProjectRoleUsageAction {
    public DeleteProjectRole(ProjectRoleService projectRoleService, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, ProjectFactory projectFactory, WorkflowManager workflowManager, SchemeFactory schemeFactory) {
        super(projectRoleService, notificationSchemeManager, permissionSchemeManager, projectFactory, workflowManager, schemeFactory);
    }

    @SupportedMethods(value={RequestMethod.GET})
    @GET
    @Operation(description="Renders a page that allows system admin to manage project roles. Managing involves deleting.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns html page.", responseCode="200")
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    @POST
    @Operation(description="Handles deleting project roles.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="Role id.", in=ParameterIn.QUERY, required=true)
    @ApiResponse(description="Returns html page.", responseCode="200")
    public String doExecute() throws Exception {
        this.projectRoleService.deleteProjectRole(this.getRole(), (ErrorCollection)this);
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("ViewProjectRoles.jspa");
    }
}

