/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractProjectRole;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@WebSudoRequired
@OpenAPIDefinition
@Path(value="secure/project/EditProjectRole!default.jspa")
@Produces(value={"text/html"})
@Tag(name="webwork")
@AdminOnly
public class EditProjectRole
extends AbstractProjectRole {
    private String name;
    private String description;

    public EditProjectRole(ProjectRoleService projectRoleService) {
        super(projectRoleService);
    }

    @SupportedMethods(value={RequestMethod.GET})
    @GET
    @Operation(description="Renders a page that allows system admin to manage project roles. Managing involves editing.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns html page.", responseCode="200")
    public String doDefault() throws Exception {
        ProjectRole roleType = this.getRole();
        this.name = roleType.getName();
        this.description = roleType.getDescription();
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getRole() == null) {
            this.addErrorMessage(this.getText("admin.errors.specified.role.does.not.exist"));
        }
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.name"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    @POST
    @Operation(description="Handles editing project roles.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="Role id.", in=ParameterIn.QUERY, required=true)
    @ApiResponse(description="Returns html page.", responseCode="200")
    public String doExecute() throws Exception {
        ProjectRole oldRole = this.getRole();
        ProjectRoleImpl role = new ProjectRoleImpl(oldRole.getId(), this.name, this.description);
        this.projectRoleService.updateProjectRole((ProjectRole)role, (ErrorCollection)this);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("ViewProjectRoles.jspa");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

