/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.GroupRoleActorFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractRoleActorAction;
import com.atlassian.jira.web.component.multigrouppicker.GroupPickerLayoutBean;
import com.atlassian.jira.web.component.multigrouppicker.GroupPickerWebComponent;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionContext;

@LicensedOnly
public class GroupRoleActorAction
extends AbstractRoleActorAction {
    private static final String REMOVE_GROUPS_PREFIX = "removegroups_";
    private String groupNames;
    private final GroupManager groupManager;

    public GroupRoleActorAction(ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory, GroupManager groupManager, PermissionManager permissionManager) {
        super(projectRoleService, permissionManager, projectManager, projectFactory, roleActorFactory);
        this.groupManager = groupManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (!this.canCurrentUserEditProjectRole()) {
            return "securitybreach";
        }
        return super.doExecute();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doRemoveGroups() {
        if (!this.canCurrentUserEditProjectRole()) {
            return "securitybreach";
        }
        Collection<String> actorsToRemove = GroupPickerWebComponent.getGroupNamesToRemove(ActionContext.getParameters(), REMOVE_GROUPS_PREFIX);
        if (!actorsToRemove.isEmpty()) {
            if (this.getProject() != null) {
                this.projectRoleService.removeActorsFromProjectRole(actorsToRemove, this.getProjectRole(), this.getProject(), "atlassian-group-role-actor", (ErrorCollection)this);
            } else {
                this.projectRoleService.removeDefaultActorsFromProjectRole(actorsToRemove, this.getProjectRole(), "atlassian-group-role-actor", (ErrorCollection)this);
            }
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.group.role.actor.action.error.remove.no.actors"));
            return "error";
        }
        this.setGroupNames(null);
        return "success";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doAddGroups() {
        if (!this.canCurrentUserEditProjectRole()) {
            return "securitybreach";
        }
        Collection<String> actorsToAdd = GroupPickerWebComponent.getGroupNamesToAdd(this.getGroupNames());
        if (actorsToAdd.isEmpty()) {
            this.addError("groupNames", this.getText("admin.group.role.actor.action.error.add.no.actors"));
        } else {
            if (this.getProject() != null) {
                this.projectRoleService.addActorsToProjectRole(actorsToAdd, this.getProjectRole(), this.getProject(), "atlassian-group-role-actor", (ErrorCollection)this);
            } else {
                this.projectRoleService.addDefaultActorsToProjectRole(actorsToAdd, this.getProjectRole(), "atlassian-group-role-actor", (ErrorCollection)this);
            }
            if (this.hasAnyErrors()) {
                return "error";
            }
        }
        this.setGroupNames(null);
        return "success";
    }

    public Collection getAvailableGroups() {
        ArrayList groups = new ArrayList(this.groupManager.getAllGroups());
        groups.removeAll(this.getCurrentGroups());
        return groups;
    }

    public Collection getCurrentGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        Set roleActorsByType = null;
        if (this.getProject() != null) {
            ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(this.getProjectRole(), this.getProject(), (ErrorCollection)this);
            if (projectRoleActors != null) {
                roleActorsByType = projectRoleActors.getRoleActorsByType("atlassian-group-role-actor");
            }
        } else {
            DefaultRoleActors defaultRoleActors = this.projectRoleService.getDefaultRoleActors(this.getProjectRole(), (ErrorCollection)this);
            if (defaultRoleActors != null) {
                roleActorsByType = defaultRoleActors.getRoleActorsByType("atlassian-group-role-actor");
            }
        }
        if (roleActorsByType != null) {
            for (RoleActor aRoleActorsByType : roleActorsByType) {
                GroupRoleActorFactory.GroupRoleActor groupRoleActor = (GroupRoleActorFactory.GroupRoleActor)aRoleActorsByType;
                groups.add(groupRoleActor.getGroup());
            }
        }
        return groups;
    }

    public String getGroupPickerHtml() {
        String removeGroupsAction = "GroupRoleActorAction!removeGroups.jspa?projectRoleId=" + this.getProjectRoleId() + (String)(this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        String addGroupAction = "GroupRoleActorAction!addGroups.jspa?projectRoleId=" + this.getProjectRoleId() + (String)(this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        GroupPickerLayoutBean groupPickerLayoutBean = new GroupPickerLayoutBean("admin.group.role.actor.action", REMOVE_GROUPS_PREFIX, removeGroupsAction, addGroupAction);
        GroupPickerWebComponent groupPickerWebComponent = new GroupPickerWebComponent();
        return groupPickerWebComponent.getHtml(groupPickerLayoutBean, this.getCurrentGroups(), true, this.getProjectRoleId(), (Map)FieldMap.build((String)"valuesToAdd", (Object)this.getGroupNamesHtmlEncoded()));
    }

    private String getGroupNames() {
        return this.groupNames;
    }

    private String getGroupNamesHtmlEncoded() {
        return TextUtils.htmlEncode((String)this.getGroupNames());
    }

    public void setGroupNames(String groupNames) {
        this.groupNames = groupNames;
    }
}

