/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

@WebSudoRequired
@AdminOnly
public class ViewWorkflowsForStatus
extends JiraWebActionSupport {
    private String id;
    private final StatusService statusService;
    private final WorkflowManager workflowManager;
    private static final Function<JiraWorkflow, String> GET_WORKFLOW_NAME = new Function<JiraWorkflow, String>(){

        public String apply(@Nullable JiraWorkflow input) {
            return input.getName();
        }
    };

    public ViewWorkflowsForStatus(StatusService statusService, WorkflowManager workflowManager) {
        this.statusService = statusService;
        this.workflowManager = workflowManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @ActionViewData
    public Status getStatus() {
        return this.statusService.getStatusById(this.getLoggedInUser(), this.id);
    }

    @ActionViewData
    public List<String> getWorkflowsForStatus() {
        List allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        final Status status = this.statusService.getStatusById(this.getLoggedInUser(), this.id);
        Iterable workflowsForStatus = Iterables.filter((Iterable)allWorkflows, (Predicate)new Predicate<JiraWorkflow>(){

            public boolean apply(@Nullable JiraWorkflow input) {
                return input.getLinkedStatusIds().contains(status.getId());
            }
        });
        ArrayList workflowNamesForStatus = Lists.newArrayList((Iterable)Iterables.transform((Iterable)workflowsForStatus, GET_WORKFLOW_NAME));
        Collections.sort(workflowNamesForStatus);
        return workflowNamesForStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

