/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.subtasks;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
@AdminOnly
public class DisableSubTasks
extends JiraWebActionSupport {
    private final SubTaskManager subTaskManager;
    private int subTaskCount;

    public DisableSubTasks(SubTaskManager subTaskManager) {
        this.subTaskManager = subTaskManager;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        Collection subTaskIssueIds = this.subTaskManager.getAllSubTaskIssueIds();
        if (subTaskIssueIds.size() > 0) {
            this.subTaskCount = subTaskIssueIds.size();
            return super.doDefault();
        }
        this.subTaskManager.disableSubTasks();
        return this.getRedirect();
    }

    private String getRedirect() throws Exception {
        return this.getRedirect("ManageSubTasks.jspa");
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return this.getRedirect();
    }

    public int getSubTaskCount() {
        return this.subTaskCount;
    }
}

