/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.systemfields;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@WebSudoRequired
@AdminOnly
public class ViewSystemFields
extends JiraWebActionSupport {
    @VisibleForTesting
    static final ImmutableList<String> AVAILABLE_SYSTEM_FIELD_IDS = ImmutableList.of((Object)"description", (Object)"summary", (Object)"issuetype", (Object)"priority", (Object)"resolution", (Object)"versions", (Object)"fixVersions", (Object)"components", (Object)"labels", (Object)"environment", (Object)"issuelinks", (Object)"attachment", (Object[])new String[]{"assignee", "reporter", "duedate", "timetracking", "security"});
    private final PageBuilderService pageBuilder;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final DCFeatureLicenseChecker licenseChecker;

    public ViewSystemFields(PageBuilderService pageBuilder, FieldManager fieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldScreenManager fieldScreenManager, DCFeatureLicenseChecker licenseChecker) {
        this.pageBuilder = pageBuilder;
        this.fieldManager = fieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.licenseChecker = licenseChecker;
    }

    private void processResources() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:viewsystemfields");
        this.pageBuilder.assembler().resources().requireContext("systemFieldsScreenListDialog");
        this.pageBuilder.assembler().resources().requireContext("systemFieldsContextListDialog");
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() throws Exception {
        this.processResources();
        return super.doExecute();
    }

    @ActionViewData
    public List<FieldDTO> getSystemFields() {
        return AVAILABLE_SYSTEM_FIELD_IDS.stream().map(arg_0 -> ((FieldManager)this.fieldManager).getField(arg_0)).filter(Objects::nonNull).map(this::toFieldDTO).collect(Collectors.toList());
    }

    private boolean isDefaultValueEnabled() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
    }

    @Nonnull
    private FieldDTO toFieldDTO(@Nonnull Field field) {
        FieldDTO.Builder builder = FieldDTO.builder(field.getId(), field.getName(), this.isDefaultValueEnabled()).setScreensCount(this.fieldScreenManager.getFieldScreenTabs(field.getId()).size());
        if (field instanceof DefaultValueField) {
            DefaultValueField defaultValueField = (DefaultValueField)field;
            return builder.setContextsCount(this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)defaultValueField).size()).build();
        }
        return builder.setConfigurable(false).build();
    }

    public static class FieldDTO {
        private final String id;
        private final String name;
        private final boolean configurable;
        private final Integer contextsCount;
        private final Integer screensCount;

        protected FieldDTO(String id, String name, boolean configurable, Integer contextsCount, Integer screensCount) {
            this.id = Objects.requireNonNull(id);
            this.name = Objects.requireNonNull(name);
            this.configurable = configurable;
            this.contextsCount = contextsCount;
            this.screensCount = screensCount;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isConfigurable() {
            return this.configurable;
        }

        public Integer getContextsCount() {
            return this.contextsCount;
        }

        public Integer getScreensCount() {
            return this.screensCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldDTO that = (FieldDTO)o;
            return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.isConfigurable(), that.isConfigurable()) && Objects.equals(this.getContextsCount(), that.getContextsCount()) && Objects.equals(this.getScreensCount(), that.getScreensCount());
        }

        public int hashCode() {
            return Objects.hash(this.getId(), this.getName(), this.isConfigurable(), this.getContextsCount(), this.getScreensCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("configurable", this.isConfigurable()).add("contextsCount", (Object)this.getContextsCount()).add("screensCount", (Object)this.getScreensCount()).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(String id, String name, boolean editable) {
            return new Builder().setId(id).setName(name).setConfigurable(editable);
        }

        public static Builder builder(FieldDTO data) {
            return new Builder(data);
        }

        public static final class Builder {
            private String id;
            private String name;
            private boolean configurable;
            private Integer contextsCount;
            private Integer screensCount;

            private Builder() {
            }

            private Builder(FieldDTO initialData) {
                this.id = initialData.getId();
                this.name = initialData.getName();
                this.configurable = initialData.isConfigurable();
                this.contextsCount = initialData.getContextsCount();
                this.screensCount = initialData.getScreensCount();
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setConfigurable(boolean configurable) {
                this.configurable = configurable;
                return this;
            }

            public Builder setContextsCount(Integer contextsCount) {
                this.contextsCount = contextsCount;
                return this;
            }

            public Builder setScreensCount(Integer screensCount) {
                this.screensCount = screensCount;
                return this;
            }

            public FieldDTO build() {
                return new FieldDTO(this.id, this.name, this.configurable, this.contextsCount, this.screensCount);
            }
        }
    }
}

