/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.task;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
@AdminOnly
public class AcknowledgeTask
extends JiraWebActionSupport {
    private Long taskId;
    private String destinationURL;
    private final TaskManager taskManager;
    private final JiraAuthenticationContext authenticationContext;

    public AcknowledgeTask(TaskManager taskManager, JiraAuthenticationContext authenticationContext) {
        this.taskManager = taskManager;
        this.authenticationContext = authenticationContext;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        TaskDescriptor descriptor;
        if (this.taskId != null && (descriptor = this.taskManager.getTask(this.taskId)) != null && descriptor.isFinished()) {
            ApplicationUser currentUser = this.authenticationContext.getUser();
            if (currentUser != null && !currentUser.getName().equals(descriptor.getUserName())) {
                this.addErrorMessage(this.getText("common.tasks.cant.acknowledge.task.you.didnt.start", descriptor.getUserName()));
                return "error";
            }
            this.taskManager.removeTask(this.taskId);
        }
        if (this.destinationURL != null) {
            return this.getRedirect(this.destinationURL);
        }
        return "success";
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String destinationURL) {
        this.destinationURL = this.getRedirectSanitiser().makeSafeRedirectUrl(destinationURL);
    }
}

