/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.translation;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@WebSudoRequired
@AdminOnly
public class ViewTranslations
extends AbstractManageIssueTypeOptionsAction {
    public static final String ISSUECONSTANT_SUBTASK = "subTask";
    public static final String TRANSLATION_PREFIX = "jira.translation.";
    public static final String STATUS_CONSTANT_NAME = "Status";
    public static final String ISSUETYPE_CONSTANT_NAME = "Issue Type";
    public static final String RESOLUTION_CONSTANT_NAME = "Resolution";
    public static final String SUBTASK_CONSTANT_NAME = "Sub-Task";
    public static final String PRIORITY_CONSTANT_NAME = "Priority";
    private final TranslationManager translationManager;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext authenticationContext;
    private final LocaleManager localeManager;
    private String issueConstantType;
    private String issueConstantName;
    private String issueConstantTranslationPrefix;
    private String redirectPage;
    private String linkName;
    private String selectedLocale;
    private Map params = new HashMap();
    private Collection<IssueConstant> issueConstants;
    public static final String LINKNAME_ISSUETYPE = "issue types";
    public static final String LINKNAME_PRIORITY = "priorities";
    public static final String LINKNAME_RESOLUTION = "resolutions";
    public static final String LINKNAME_STATUS = "statuses";
    public static final String LINKNAME_SUBTASK = "sub-tasks";

    public ViewTranslations(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, TranslationManager translationManager, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, IssueManager issueManager, LocaleManager localeManager, IssueTypeSchemeService issueTypeSchemeService) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, issueManager, issueTypeSchemeService);
        this.translationManager = translationManager;
        this.constantsManager = constantsManager;
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        if (this.getSelectedLocale() == null) {
            Map installedLocales;
            String currentLocale = this.getUserPreferences().getString("jira.user.locale");
            if (currentLocale == null) {
                currentLocale = this.getCurrentLocale();
            }
            if ((installedLocales = this.getInstalledLocales()).isEmpty()) {
                currentLocale = Locale.getDefault().toString();
            } else if (!installedLocales.containsKey(currentLocale)) {
                currentLocale = (String)installedLocales.keySet().iterator().next();
            }
            this.setSelectedLocale(currentLocale);
        }
        if (this.getErrorMessages().size() == 0) {
            this.initParamsMap();
        }
        return "success";
    }

    public void doValidation() {
        this.params = ActionContext.getParameters();
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = this.getNameKey(issueConstant);
            String issueConstantDescriptionKey = this.getDescKey(issueConstant);
            if (!this.params.containsKey(issueConstantDescriptionKey) || !this.params.containsKey(issueConstantNameKey)) continue;
            String nameTranslation = ((String[])this.params.get(issueConstantNameKey))[0];
            String descTranslation = ((String[])this.params.get(issueConstantDescriptionKey))[0];
            if (!(StringUtils.isNotEmpty((CharSequence)nameTranslation) ^ StringUtils.isNotEmpty((CharSequence)descTranslation))) continue;
            this.addError(this.getNameKey(issueConstant), this.getText("admin.errors.translation.name.description.pair.must.be.provided"));
            this.log.error((Object)"A name/description translation pair must be provided.");
        }
    }

    private void initParamsMap() {
        this.params.clear();
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = this.getNameKey(issueConstant);
            String issueConstantDescriptionKey = this.getDescKey(issueConstant);
            if (!this.hasTranslatedValue(issueConstant)) continue;
            this.params.put(issueConstantNameKey, issueConstant.getNameTranslation(this.getSelectedLocale()));
            this.params.put(issueConstantDescriptionKey, issueConstant.getDescTranslation(this.getSelectedLocale()));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        this.params = ActionContext.getParameters();
        Locale locale = this.localeManager.getLocale(this.getSelectedLocale());
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = this.getNameKey(issueConstant);
            String issueConstantDescriptionKey = this.getDescKey(issueConstant);
            if (!this.params.containsKey(issueConstantNameKey) || !this.params.containsKey(issueConstantDescriptionKey)) continue;
            String nameTranslation = ((String[])this.params.get(issueConstantNameKey))[0];
            String descTranslation = ((String[])this.params.get(issueConstantDescriptionKey))[0];
            if (StringUtils.isNotEmpty((CharSequence)nameTranslation) && StringUtils.isNotEmpty((CharSequence)descTranslation)) {
                this.translationManager.setIssueConstantTranslation(issueConstant, this.getIssueConstantTranslationPrefix(), locale, nameTranslation, descTranslation);
                continue;
            }
            this.translationManager.deleteIssueConstantTranslation(issueConstant, this.getIssueConstantTranslationPrefix(), locale);
        }
        return this.getRedirect("ViewTranslations!default.jspa?issueConstantType=" + this.getIssueConstantType() + "&selectedLocale=" + this.getSelectedLocale());
    }

    public String getIssueConstantName() {
        if (this.issueConstantName == null) {
            String issueConstantType = this.getIssueConstantType();
            if ("issuetype".equals(issueConstantType)) {
                this.issueConstantName = this.getText("admin.issue.constant.issuetype");
            } else if ("priority".equals(issueConstantType)) {
                this.issueConstantName = this.getText("admin.issue.constant.priority");
            } else if ("resolution".equals(issueConstantType)) {
                this.issueConstantName = this.getText("admin.issue.constant.resolution");
            } else if ("status".equals(issueConstantType)) {
                this.issueConstantName = this.getText("admin.issue.constant.status");
            } else if (ISSUECONSTANT_SUBTASK.equals(issueConstantType)) {
                this.issueConstantName = this.getText("admin.issue.constant.subtask");
            }
        }
        return this.issueConstantName;
    }

    public String getIssueConstantTranslationPrefix() {
        if (this.issueConstantTranslationPrefix == null) {
            String issueConstantType = this.getIssueConstantType();
            if ("issuetype".equals(issueConstantType)) {
                this.issueConstantTranslationPrefix = "jira.translation.issuetype";
            } else if ("priority".equals(issueConstantType)) {
                this.issueConstantTranslationPrefix = "jira.translation.priority";
            } else if ("resolution".equals(issueConstantType)) {
                this.issueConstantTranslationPrefix = "jira.translation.resolution";
            } else if ("status".equals(issueConstantType)) {
                this.issueConstantTranslationPrefix = "jira.translation.status";
            } else if (ISSUECONSTANT_SUBTASK.equals(issueConstantType)) {
                this.issueConstantTranslationPrefix = "jira.translation.issuetype";
            }
        }
        return this.issueConstantTranslationPrefix;
    }

    public String getRedirectPage() {
        if (this.redirectPage == null) {
            String issueConstantType = this.getIssueConstantType();
            if ("issuetype".equals(issueConstantType)) {
                this.redirectPage = "ViewIssueTypes.jspa";
            } else if ("priority".equals(issueConstantType)) {
                this.redirectPage = "ViewPriorities.jspa";
            } else if ("resolution".equals(issueConstantType)) {
                this.redirectPage = "ViewResolutions.jspa";
            } else if ("status".equals(issueConstantType)) {
                this.redirectPage = "ViewStatuses.jspa";
            } else if (ISSUECONSTANT_SUBTASK.equals(issueConstantType)) {
                this.redirectPage = "ManageSubTasks.jspa";
            }
        }
        return this.redirectPage;
    }

    public Collection<IssueConstant> getIssueConstants() {
        if (this.issueConstants == null) {
            String issueConstantType = this.getIssueConstantType();
            this.issueConstants = "issuetype".equals(issueConstantType) ? new ArrayList<IssueConstant>(this.constantsManager.getRegularIssueTypeObjects()) : ("priority".equals(issueConstantType) ? new ArrayList<IssueConstant>(this.constantsManager.getPriorities()) : ("resolution".equals(issueConstantType) ? new ArrayList<IssueConstant>(this.constantsManager.getResolutions()) : ("status".equals(issueConstantType) ? new ArrayList<IssueConstant>(this.constantsManager.getStatuses()) : (ISSUECONSTANT_SUBTASK.equals(issueConstantType) ? new ArrayList<IssueConstant>(this.constantsManager.getSubTaskIssueTypeObjects()) : new ArrayList<IssueConstant>()))));
        }
        return this.issueConstants;
    }

    public String getLinkName() {
        if (this.linkName == null) {
            String issueConstantType = this.getIssueConstantType();
            if ("issuetype".equals(issueConstantType)) {
                this.linkName = LINKNAME_ISSUETYPE;
            } else if ("priority".equals(issueConstantType)) {
                this.linkName = LINKNAME_PRIORITY;
            } else if ("resolution".equals(issueConstantType)) {
                this.linkName = LINKNAME_RESOLUTION;
            } else if ("status".equals(issueConstantType)) {
                this.linkName = LINKNAME_STATUS;
            } else if (ISSUECONSTANT_SUBTASK.equals(issueConstantType)) {
                this.linkName = LINKNAME_SUBTASK;
            }
        }
        return this.linkName;
    }

    public String getCurrentLocale() {
        return this.authenticationContext.getLocale().toString();
    }

    public String getSelectedLocaleDisplayName() {
        return this.localeManager.getLocale(this.getSelectedLocale()).getDisplayName(this.authenticationContext.getLocale());
    }

    public String getNameKey(IssueConstant issueConstant) {
        return TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".name";
    }

    public String getDescKey(IssueConstant issueConstant) {
        return TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".desc";
    }

    public String getTranslatedName(IssueConstant issueConstant) {
        Object param = this.params.get(this.getNameKey(issueConstant));
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        if (param instanceof String) {
            return (String)param;
        }
        return null;
    }

    public String getTranslatedDesc(IssueConstant issueConstant) {
        Object param = this.params.get(this.getDescKey(issueConstant));
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        if (param instanceof String) {
            return (String)param;
        }
        return null;
    }

    private boolean hasTranslatedValue(IssueConstant issueConstant) {
        return this.translationManager.hasLocaleTranslation(issueConstant, this.getSelectedLocale());
    }

    public Map getInstalledLocales() {
        return this.translationManager.getInstalledLocales();
    }

    public String getIssueConstantType() {
        return this.issueConstantType;
    }

    public void setIssueConstantType(String issueConstantType) {
        this.issueConstantType = issueConstantType;
    }

    public boolean isIssueConstantTypeStatus() {
        return "status".equals(this.getIssueConstantType());
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    public void setSelectedLocale(String selectedLocale) {
        this.selectedLocale = selectedLocale;
    }

    public String getActionType() {
        return "translate";
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

