/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.group.GroupRemoveChildMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.GroupOption;
import com.atlassian.jira.issue.fields.option.UserOption;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class BulkEditUserGroups
extends JiraWebActionSupport {
    private String[] selectedGroupsStr;
    private List<Group> selectedGroups;
    private String[] usersToUnassign;
    private Collection<String> usersToAssignMultiSelect = new ArrayList<String>();
    private HashSet<String> prunedUsersToAssign = new HashSet();
    private ArrayList<GroupOption> membersList;
    private ArrayList<String> overloadedGroups;
    private String assign;
    private String unassign;
    private Integer maxMembers;
    private final ApplicationProperties applicationProperties;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GroupService groupService;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private static final int MAX_LIST_SIZE = 20;
    private static final String OPTION_VALUE_SEPARATOR = ",";

    public BulkEditUserGroups(GroupManager groupManager, ApplicationProperties applicationProperties, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupService groupService, UserManager userManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.applicationProperties = applicationProperties;
        this.groupService = groupService;
        this.groupManager = groupManager;
        this.userManager = userManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public void doValidation() {
        super.doValidation();
        if (this.selectedGroupsStr == null || this.selectedGroupsStr.length == 0) {
            this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.group.selected"));
            return;
        }
        if (TextUtils.stringSet((String)this.assign)) {
            if (this.getUsersToAssign() == null || this.getUsersToAssign().isEmpty()) {
                this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.users.to.add"));
                return;
            }
            GroupService.BulkEditGroupValidationResult bulkEditGroupValidationResult = this.groupService.validateAddUsersToGroup(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), this.getUsersToAssign());
            if (!bulkEditGroupValidationResult.isSuccess()) {
                HashSet<String> validUsers = new HashSet<String>(this.getUsersToAssign());
                Collection invalidChildren = bulkEditGroupValidationResult.getInvalidChildren();
                validUsers.removeAll(invalidChildren);
                this.prunedUsersToAssign = validUsers;
            }
        } else if (TextUtils.stringSet((String)this.unassign)) {
            if (this.usersToUnassign == null || this.usersToUnassign.length <= 0) {
                this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.users.to.remove"));
                return;
            }
            this.groupService.validateRemoveUsersFromGroups(this.getJiraServiceContext(), this.getGroupRemoveUserMapper());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (TextUtils.stringSet((String)this.assign)) {
            this.groupService.addUsersToGroups(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), this.getUsersToAssign());
        } else if (TextUtils.stringSet((String)this.unassign)) {
            this.groupService.removeUsersFromGroups(this.getJiraServiceContext(), this.getGroupRemoveUserMapper());
        }
        return this.redirectToView();
    }

    public Collection<Group> getAllVisibleGroups() {
        return this.globalPermissionGroupAssociationUtil.getGroupsModifiableByCurrentUser(this.getLoggedInUser(), new ArrayList<Group>(this.groupManager.getAllGroups()));
    }

    public boolean getIsGroupSelected(Group group) {
        return this.getSelectedGroupsUserHasPermToSee() != null && this.getSelectedGroupsUserHasPermToSee().contains(group);
    }

    public Collection<GroupOption> getMembersList() {
        List groupNames;
        Collection collection;
        if (this.membersList != null) {
            return this.membersList;
        }
        List<Group> groups = this.getSelectedGroupsUserHasPermToSee();
        if (groups == null) {
            return null;
        }
        Stopwatch timer = this.log.isDebugEnabled() ? Stopwatch.createStarted() : null;
        this.membersList = new ArrayList();
        this.overloadedGroups = new ArrayList();
        LinkedHashMultimap groupedUsers = LinkedHashMultimap.create();
        HashSet allUserNames = new HashSet();
        int limit = this.getMaxUsersDisplayedPerGroup();
        for (Group group : groups) {
            Collection userNames = this.groupManager.getNamesOfDirectMembersOfGroups(Collections.singleton(group.getName()), limit + 1);
            if (userNames.size() > limit) {
                this.overloadedGroups.add(group.getName());
                userNames = userNames.stream().limit(limit).collect(Collectors.toList());
            }
            allUserNames.addAll(userNames);
            groupedUsers.putAll((Object)group, (Iterable)userNames);
        }
        if (groups.size() > 1 && !(collection = this.groupManager.filterUsersInAllGroupsDirect(allUserNames, groupNames = groups.stream().map(Group::getName).collect(Collectors.toList()))).isEmpty()) {
            this.addGroupOption(new GroupOption(this.getText("admin.bulkeditgroups.all.selected.groups")), collection);
            groupedUsers = Multimaps.filterValues((Multimap)groupedUsers, (Predicate)Predicates.not(collection::contains));
        }
        for (Map.Entry entry : groupedUsers.asMap().entrySet()) {
            Collection userNamesInGroup = (Collection)entry.getValue();
            if (userNamesInGroup.isEmpty()) continue;
            this.addGroupOption(new GroupOption((Group)entry.getKey()), userNamesInGroup);
        }
        if (timer != null) {
            this.log.debug((Object)("Retrieving [" + allUserNames.size() + "] members in [" + groups.size() + "] groups took " + timer));
        }
        return this.membersList;
    }

    private void addGroupOption(GroupOption groupOption, Collection<String> userNamesInGroup) {
        for (String userName : userNamesInGroup) {
            groupOption.addChildOption(new UserOption(userName));
        }
        this.membersList.add(groupOption);
    }

    public int getAssignedUsersCount() {
        int assignedUsersCount = 0;
        for (GroupOption groupOption : this.getMembersList()) {
            assignedUsersCount += groupOption.getChildOptions().size();
        }
        return assignedUsersCount;
    }

    public int getAssignedUsersListSize() {
        return this.getListSize(this.getAssignedUsersCount() + this.getMembersList().size());
    }

    public int getListSize(int size) {
        return size < 20 ? size : 20;
    }

    public String getOptionValue(UserOption userOption) {
        if (userOption != null) {
            GroupOption parentOption = userOption.getParentOption();
            if (parentOption != null && parentOption.getGroup() != null) {
                return userOption.getName() + OPTION_VALUE_SEPARATOR + parentOption.getRawName();
            }
            return userOption.getName();
        }
        return "";
    }

    public String getUnassign() {
        return this.unassign;
    }

    public void setUnassign(String unassign) {
        this.unassign = unassign;
    }

    public String getAssign() {
        return this.assign;
    }

    public void setAssign(String assign) {
        this.assign = assign;
    }

    public String[] getSelectedGroupsStr() {
        return this.selectedGroupsStr;
    }

    public void setSelectedGroupsStr(String[] selectedGroupsStr) {
        this.selectedGroupsStr = selectedGroupsStr;
    }

    public List<Group> getSelectedGroupsUserHasPermToSee() {
        if (this.selectedGroupsStr == null) {
            return new ArrayList<Group>();
        }
        if (this.selectedGroups == null) {
            ArrayList<Group> selectedGroupsHolder = new ArrayList<Group>();
            for (String groupName : this.selectedGroupsStr) {
                Group group = this.groupManager.getGroup(groupName);
                if (group == null) continue;
                selectedGroupsHolder.add(group);
            }
            this.selectedGroups = this.globalPermissionGroupAssociationUtil.getGroupsModifiableByCurrentUser(this.getLoggedInUser(), selectedGroupsHolder);
        }
        return this.selectedGroups;
    }

    @Deprecated
    public void setUsersToAssignStr(String usersToAssignStr) {
        if (StringUtils.isNotBlank((CharSequence)usersToAssignStr)) {
            Collection processedUserList = Arrays.asList(usersToAssignStr.split(OPTION_VALUE_SEPARATOR)).stream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList());
            this.setUsersToAssignMultiSelect(processedUserList);
        }
    }

    @Deprecated
    public String getUsersToAssignStr() {
        return StringUtils.join(this.getUsersToAssign(), (String)", ");
    }

    public String[] getUsersToAssignMultiSelect() {
        return this.usersToAssignMultiSelect.toArray(new String[this.usersToAssignMultiSelect.size()]);
    }

    public void setUsersToAssignMultiSelect(String[] usersToAssignMultiSelect) {
        this.setUsersToAssignMultiSelect(Arrays.asList(usersToAssignMultiSelect));
    }

    public void setUsersToAssignMultiSelect(Collection<String> usersToAssignMultiSelect) {
        this.usersToAssignMultiSelect = usersToAssignMultiSelect;
    }

    public Collection<ApplicationUser> getUsersToAssignToTheMultiSelect() {
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>();
        for (String username : this.getUsersToAssign()) {
            users.add(this.userManager.getUserByName(username));
        }
        return users;
    }

    private Collection<String> getUsersToAssign() {
        return this.usersToAssignMultiSelect;
    }

    public Collection<String> getPrunedUsersToAssign() {
        return this.prunedUsersToAssign;
    }

    public void setUsersToUnassign(String[] usersToUnassign) {
        this.usersToUnassign = usersToUnassign;
    }

    public String[] getUsersToUnassign() {
        return this.usersToUnassign;
    }

    public boolean isTooManyUsersListed() {
        return this.overloadedGroups != null && !this.overloadedGroups.isEmpty();
    }

    public int getMaxUsersDisplayedPerGroup() {
        if (this.maxMembers == null) {
            int MAX_USERS_DISPLAYED_PER_GROUP = 200;
            String maxMembersStr = this.applicationProperties.getDefaultBackedString("jira.usermanagement.maxdisplaymembers");
            if (maxMembersStr != null) {
                try {
                    this.maxMembers = Integer.valueOf(maxMembersStr.trim());
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Invalid format of 'jira.usermanagement.maxdisplaymembers' property: '" + maxMembersStr + "'. Value should be an integer. Using 200"));
                    this.maxMembers = 200;
                }
            } else {
                this.log.debug((Object)"'jira.usermanagement.maxdisplaymembers' is missing. Using 200 instead.");
                this.maxMembers = 200;
            }
        }
        return this.maxMembers;
    }

    public String getPrettyPrintOverloadedGroups() {
        StringBuilder sb = new StringBuilder();
        int length = this.overloadedGroups.size();
        for (int i = 0; i < length; ++i) {
            sb.append(this.overloadedGroups.get(i));
            if (i == length - 2 && length > 1) {
                sb.append(" ").append(this.getText("common.words.and")).append(" ");
                continue;
            }
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private GroupRemoveChildMapper getGroupRemoveUserMapper() {
        GroupRemoveChildMapper groupRemoveChildMapper = new GroupRemoveChildMapper(Arrays.asList(this.selectedGroupsStr));
        for (String anUsersToUnassign : this.usersToUnassign) {
            String username = this.extractUserName(anUsersToUnassign);
            String groupname = this.extractGroupName(anUsersToUnassign);
            if (groupname != null) {
                groupRemoveChildMapper.register(username, groupname);
                continue;
            }
            groupRemoveChildMapper.register(username);
        }
        return groupRemoveChildMapper;
    }

    private String extractUserName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPARATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(0, splitIndex);
        }
        return optionValue;
    }

    private String extractGroupName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPARATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(splitIndex + OPTION_VALUE_SEPARATOR.length());
        }
        return null;
    }

    private String redirectToView() {
        StringBuilder redirectUrl = new StringBuilder("BulkEditUserGroups!default.jspa?");
        Iterator<Group> groups = this.getSelectedGroupsUserHasPermToSee().iterator();
        while (groups.hasNext()) {
            Group group = groups.next();
            redirectUrl.append("selectedGroupsStr=").append(JiraUrlCodec.encode((String)group.getName()));
            if (!groups.hasNext()) continue;
            redirectUrl.append("&");
        }
        return this.getRedirect(redirectUrl.toString());
    }
}

