/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.UserProperty;
import com.opensymphony.module.propertyset.PropertySet;

@AdminOnly
public class DeleteUserProperty
extends UserProperty {
    private boolean confirm;

    public DeleteUserProperty(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        if (this.getUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.users.user.does.not.exist"));
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm && !this.hasAnyErrors()) {
            String trueKey = this.getTrueKey();
            PropertySet ps = this.userPropertyManager.getPropertySet(this.getUser());
            if (ps.exists(trueKey)) {
                ps.remove(trueKey);
            }
        }
        return this.returnComplete("EditUserProperties.jspa?name=" + JiraUrlCodec.encode((String)this.getName()));
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

