/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleComparator;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.UserBrowserFilter;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;
import webwork.util.BeanUtil;

@WebSudoRequired
@AdminOnly
public class UserBrowser
extends AbstractBrowser {
    private static final ObjectMapper OBJECT_MAPPER;
    private List<ApplicationUser> users;
    private String[] createdUser;
    private final UserUtil userUtil;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final SimpleLinkManager simpleLinkManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final PageBuilderService pageBuilderService;
    private final FeatureManager featureManager;
    private static final String EMPTY_FILTER_VALUE = "";

    public UserBrowser(UserUtil userUtil, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserManager userManager, AvatarService avatarService, SimpleLinkManager simpleLinkManager, ApplicationRoleManager applicationRoleManager, PageBuilderService pageBuilderService, FeatureManager featureManager) {
        this.userUtil = userUtil;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.simpleLinkManager = simpleLinkManager;
        this.applicationRoleManager = applicationRoleManager;
        this.pageBuilderService = pageBuilderService;
        this.featureManager = featureManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        String userSearchFilter = this.getSingleParam("userSearchFilter");
        String applicationFilterParam = this.getSingleParam("applicationFilter");
        String groupParam = this.getSingleParam("group");
        String activeFilter = this.getSingleParam("activeFilter");
        String maxUsersPerPage = this.getSingleParam("max");
        if (EMPTY_FILTER_VALUE.equals(userSearchFilter) || EMPTY_FILTER_VALUE.equals(groupParam) || StringUtils.isNotEmpty((CharSequence)applicationFilterParam) || this.getCreatedUsers().findAny().isPresent() || EMPTY_FILTER_VALUE.equals(activeFilter)) {
            this.resetPager();
            this.setStart("0");
        }
        BeanUtil.setProperties((Map)this.params, (Object)((Object)this.getFilter()));
        if (TextUtils.stringSet((String)maxUsersPerPage)) {
            this.getFilter().setMax(Integer.parseInt(maxUsersPerPage));
        }
        if (this.getBrowsableItems().size() <= this.getPager().getStart()) {
            this.setStart("0");
        }
        this.requireCreatedUsersNames();
        return super.doExecute();
    }

    protected void requireCreatedUsersNames() {
        this.pageBuilderService.assembler().data().requireData("UserBrowser:createdUsersDisplayNames", writer -> OBJECT_MAPPER.writeValue(writer, this.getCreatedUsersDisplayNames()));
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.user.filter", null);
    }

    public UserBrowserFilter getFilter() {
        UserBrowserFilter filter = (UserBrowserFilter)((Object)ActionContext.getSession().get("jira.user.filter"));
        if (filter == null) {
            filter = new UserBrowserFilter(this.getLocale(), this.applicationRoleManager);
            ActionContext.getSession().put("jira.user.filter", filter);
        }
        return filter;
    }

    @Override
    public List<ApplicationUser> getCurrentPage() {
        Set createdUsers = (Set)this.getCreatedUsers().collect(CollectorsUtil.toImmutableSet());
        Stream<ApplicationUser> currentPage = this.getFilter().getCurrentPage(this.getBrowsableItems()).stream().filter(user -> !createdUsers.contains(user));
        return (List)Stream.concat(createdUsers.stream(), currentPage).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public List<ApplicationUser> getBrowsableItems() {
        if (this.users == null) {
            try {
                this.users = this.getFilter().getFilteredUsers();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting users: " + e), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.users;
    }

    public Iterator getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return this.crowdService.search((Query)query).iterator();
    }

    public Iterator getGroupsForUser(ApplicationUser user) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery).iterator();
    }

    public Iterator<ApplicationRole> getApplicationRolesForUser(ApplicationUser user) {
        return this.applicationRoleManager.getOccupiedLicenseRolesForUser(user).stream().sorted(new ApplicationRoleComparator(this.getLocale())).iterator();
    }

    public List<ApplicationRoleSelectItem> getApplicationRoles() {
        Set roles = this.applicationRoleManager.getRoles();
        ImmutableList.Builder defaults = ImmutableList.builder();
        if (roles.size() > 1) {
            defaults.add((Object)new ApplicationRoleSelectItem("-1", this.getI18nHelper().getText("common.filters.any")));
        }
        defaults.add((Object)new ApplicationRoleSelectItem("-2", this.getI18nHelper().getText("common.words.none")));
        return (List)Stream.concat(defaults.build().stream(), roles.stream().sorted(new ApplicationRoleComparator(this.getLocale())).map(ApplicationRoleSelectItem::of)).collect(CollectorsUtil.toImmutableList());
    }

    public List<ActiveUserSelectItem> getActiveUsersSelectItems() {
        return ImmutableList.of((Object)new ActiveUserSelectItem(this.getI18nHelper().getText("admin.userbrowser.active"), true), (Object)new ActiveUserSelectItem(this.getI18nHelper().getText("admin.userbrowser.inactive"), false));
    }

    public String getDirectoryForUser(ApplicationUser user) {
        return this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName();
    }

    public Collection<ApplicationUser> getUsers() {
        return this.getBrowsableItems();
    }

    public boolean isRemoteUserPermittedToEditSelectedUser(ApplicationUser user) {
        return user != null && this.userManager.canUpdateUser(user) && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, user));
    }

    @Nonnull
    private Stream<ApplicationUser> getCreatedUsers() {
        return this.getCreatedUserNames().map(arg_0 -> ((UserManager)this.userManager).getUserByName(arg_0)).filter(Objects::nonNull);
    }

    private Stream<String> getCreatedUserNames() {
        if (this.createdUser == null) {
            return Stream.empty();
        }
        return Arrays.stream(this.getCreatedUser());
    }

    @Nonnull
    private List<String> getCreatedUsersDisplayNames() {
        return (List)this.getCreatedUsers().map(ApplicationUser::getDisplayName).collect(CollectorsUtil.toImmutableList());
    }

    public boolean isUserFocused(ApplicationUser user) {
        return this.getCreatedUserNames().anyMatch(user.getUsername()::equals);
    }

    public String[] getCreatedUser() {
        return this.createdUser;
    }

    public void setCreatedUser(String[] createdUser) {
        this.createdUser = createdUser;
    }

    public boolean isRemoteUserPermittedToEditSelectedUsersGroups(ApplicationUser user) {
        return this.userManager.canUpdateGroupMembershipForUser(user);
    }

    public boolean isCanAnonymizeUser(ApplicationUser userToAnonymize) {
        return userToAnonymize != null && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.GDPR_RTBF) && this.isDifferentThanLoggedInUser(userToAnonymize) && this.hasPermissionsToAnonymize(userToAnonymize);
    }

    private boolean isDifferentThanLoggedInUser(@Nonnull ApplicationUser userToAnonymize) {
        String loggedInUserKey = this.getLoggedInUser() != null ? this.getLoggedInUser().getKey() : null;
        return !Objects.equals(userToAnonymize.getKey(), loggedInUserKey);
    }

    private boolean hasPermissionsToAnonymize(@Nonnull ApplicationUser userToAnonymize) {
        if (this.isSystemAdministrator()) {
            return true;
        }
        return this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.ADMINISTER, this.getLoggedInUser()) && !this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, userToAnonymize);
    }

    public UserUtil getUserUtil() {
        return this.userUtil;
    }

    public URI getAvatarUrl(String username) {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), username, Avatar.Size.SMALL);
    }

    public Collection<SimpleLink> getOpsbarLinks() {
        return this.simpleLinkManager.getLinksForSection("system.admin.userbrowser.opsbar", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap params = new HashMap();
        return new JiraHelper(ServletActionContext.getRequest(), null, params);
    }

    public static String getActionUrl(Optional<String> queryString, Optional<String> flag) {
        return "UserBrowser.jspa" + queryString.map(s -> "?" + s).orElse(EMPTY_FILTER_VALUE) + flag.map(s -> "#" + s).orElse(EMPTY_FILTER_VALUE);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }

    public static class ApplicationRoleSelectItem {
        private final String name;
        private final String value;

        public ApplicationRoleSelectItem(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public static ApplicationRoleSelectItem of(ApplicationRole role) {
            return new ApplicationRoleSelectItem(role.getKey().value(), role.getName());
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).toString();
        }
    }

    public static class ActiveUserSelectItem {
        private final String name;
        private final Boolean value;

        public ActiveUserSelectItem(String name, Boolean value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getValue() {
            return this.value;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).toString();
        }
    }
}

