/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.seraph.service.rememberme.RememberMeToken;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import java.util.Date;
import java.util.List;

@AdminOnly
public class UserRememberMeCookies
extends ViewUser {
    private final OutlookDateManager outlookDateManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RememberMeTokenDao rememberMeTokenDao;
    private List<RememberMeToken> rememberMeTokenList;

    public UserRememberMeCookies(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, RememberMeTokenDao rememberMeTokenDao, OutlookDateManager outlookDateManager, UserManager userManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.outlookDateManager = outlookDateManager;
        this.rememberMeTokenDao = rememberMeTokenDao;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    @Override
    protected void doValidation() {
        super.doValidation();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.rememberMeTokenDao.removeAllForUser(this.name);
        return "input";
    }

    public List<RememberMeToken> getTokens() {
        if (this.rememberMeTokenList == null) {
            this.rememberMeTokenList = this.rememberMeTokenDao.findForUserName(this.name);
        }
        return this.rememberMeTokenList;
    }

    public String getFormattedDate(long time) {
        return this.dateTimeFormatterFactory.formatter().withLocale(this.getLocale()).format(new Date(time));
    }
}

