/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class CreateDraftWorkflow
extends JiraWebActionSupport {
    private String draftWorkflowName;
    private final WorkflowService workflowService;

    public CreateDraftWorkflow(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void doValidation() {
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.workflowService.createDraftWorkflow(this.getJiraServiceContext(), StringUtils.trim((String)this.getDraftWorkflowName()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("ViewWorkflowSteps.jspa?workflowMode=draft&workflowName=" + JiraUrlCodec.encode((String)StringUtils.trim((String)this.getDraftWorkflowName())));
    }

    public String getDraftWorkflowName() {
        return this.draftWorkflowName;
    }

    public void setDraftWorkflowName(String draftWorkflowName) {
        this.draftWorkflowName = draftWorkflowName;
    }
}

